/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pt.opensoft.field.AbstractValidator;
import pt.opensoft.field.MaxErrorsExceededException;
import pt.opensoft.field.ValidationException;
import pt.opensoft.xml.XmlElement;
import pt.opensoft.xml.XmlProcessor;
import pt.opensoft.xml.XmlReader;

public abstract class XmlValidator
extends AbstractValidator
implements XmlProcessor,
ErrorHandler {
    protected XmlReader reader = new XmlReader(this);

    public XmlValidator(String name) {
        super(name);
        this.reader.setErrorHandler(this);
    }

    protected void setSchema(String schemas) {
        this.reader.setSchema(schemas);
    }

    @Override
    public Vector validate(Object value) {
        block9: {
            try {
                if (value instanceof File) {
                    this.reader.parse((File)value);
                    break block9;
                }
                if (value instanceof InputStream) {
                    this.reader.parse((InputStream)value);
                    break block9;
                }
                if (value instanceof Reader) {
                    this.reader.parse((Reader)value);
                    break block9;
                }
                throw new IllegalArgumentException("validate(" + value.getClass().getName() + ") not implemented");
            }
            catch (MaxErrorsExceededException maxErrorsExceededException) {
            }
            catch (SAXParseException sAXParseException) {
            }
            catch (SAXException e) {
                this.error(new ValidationException("XML", e.getLocalizedMessage()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.error(new ValidationException("XML", e.getLocalizedMessage()));
            }
        }
        return this.getErrors();
    }

    @Override
    public abstract void startElement(XmlElement var1, int var2, int var3) throws Exception;

    @Override
    public abstract void endElement(XmlElement var1, int var2, int var3) throws Exception;

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.error(new ValidationException("XML", e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.error(new ValidationException("XML", e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.error(new ValidationException("XML", e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber()));
        e.printStackTrace();
        throw e;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.reader.setEntityResolver(resolver);
    }
}

