/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import pt.opensoft.text.Base64Encoder;
import pt.opensoft.util.CharUtil;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.StringUtil;

public class VelocityUtil {
    public final String listToStr(List list) {
        return ListUtil.toString(list, ", ");
    }

    public final String padL(String src, String ch, int length) {
        return StringUtil.padChars(src, ch.charAt(0), length, true);
    }

    public final String padR(String src, char pad, int length) {
        return StringUtil.padChars(src, pad, length, false);
    }

    public final String escape(String st) {
        return StringUtil.sanitize(st);
    }

    public final String removeQuotes(String str) {
        return StringUtil.remove(str, "'");
    }

    public final String capitalize(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toUpperCase(str.charAt(0)));
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            char last = str.charAt(i - 1);
            if (last == ' ') {
                buffer.append(Character.toUpperCase(ch));
                continue;
            }
            buffer.append(Character.toLowerCase(ch));
        }
        return buffer.toString();
    }

    public final int parseInt(String s) {
        return Integer.parseInt(s);
    }

    public final boolean hasQuotes(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!CharUtil.isQuote(c)) continue;
            return true;
        }
        return false;
    }

    public final String escapeQuoteChars(String string) {
        String escapedString = string;
        for (int i = 0; i < "\"'\u00b4`".length(); ++i) {
            char quote = "\"'\u00b4`".charAt(i);
            escapedString = escapedString.replaceAll(String.valueOf(quote), "\\\\" + quote);
        }
        return escapedString;
    }

    public final String module(int numero) {
        if (StringUtil.isSignedNumeric(String.valueOf(numero))) {
            return String.valueOf(numero < 0 ? numero * -1 : numero);
        }
        return String.valueOf(numero);
    }

    public final String encodeBase64(String str) {
        return this.encodeBase64(str, "UTF-8");
    }

    public final String encodeBase64(String str, String encoding) {
        if (str == null) {
            return str;
        }
        try {
            return Base64Encoder.encodeBuffer(str.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public final String toHtml(String str) {
        return StringUtil.toHtml(str);
    }
}

