/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import pt.opensoft.msg.Request;
import pt.opensoft.msg.ValidateException;
import pt.opensoft.util.StringUtil;

public class PageManager {
    public static final String PAGE_PARAMETER = "page";
    private final int listMax;
    private final Request request;

    public PageManager(Request request, int listMax) {
        this.request = request;
        this.listMax = listMax;
    }

    public int getPageNumber() {
        String pageStr = this.request.getString(PAGE_PARAMETER);
        if (pageStr != null) {
            if (!StringUtil.isNumeric(pageStr)) {
                throw new ValidateException(PAGE_PARAMETER, "A P\u00e1gina indicada \u00e9 inv\u00e1lida: " + pageStr);
            }
            return Integer.parseInt(pageStr);
        }
        return 1;
    }

    public int getTotalNumberOfPages(int count) {
        return count / this.listMax + (count % this.listMax > 0 ? 1 : 0);
    }

    public int getOffset(int page, int numberOfPages) {
        if (page < 1) {
            page = 1;
        } else if (page > numberOfPages) {
            page = numberOfPages;
        }
        return (page - 1) * this.listMax;
    }
}

