/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MultipleResourceBundle {
    private final List<ResourceBundle> resourceBundles;
    private final Locale locale;

    public MultipleResourceBundle(List<ResourceBundle> resourceBundles, Locale locale) {
        this.resourceBundles = resourceBundles;
        this.locale = locale;
    }

    public List<ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        for (ResourceBundle bundle : this.resourceBundles) {
            if (!bundle.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public String getString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        for (ResourceBundle bundle : this.resourceBundles) {
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        throw new MissingResourceException("There is no value for key " + key, MultipleResourceBundle.class.getName(), key);
    }
}

