/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import pt.opensoft.io.ResourceFactory;
import pt.opensoft.io.ResourceNotFoundException;

public class ZipResourceFactory
implements ResourceFactory {
    protected ZipFile zipFile;

    public ZipResourceFactory(File file) throws IOException {
        this.zipFile = file.exists() && !file.isDirectory() ? new ZipFile(file) : null;
    }

    public ZipResourceFactory(String zipFilePath) throws IOException {
        this(new File(zipFilePath));
    }

    @Override
    public Set getResourcePaths(String path) throws ResourceNotFoundException {
        if (this.zipFile == null) {
            return null;
        }
        TreeSet<String> resourcePaths = new TreeSet<String>();
        Enumeration<? extends ZipEntry> en = this.zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            resourcePaths.add(entry.getName());
        }
        return resourcePaths;
    }

    @Override
    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        if (this.zipFile == null) {
            throw new ResourceNotFoundException("[ResourceLoader] Zip Resource Factory: " + source + " not found (Zip File Not Found).");
        }
        String normalizedSource = source.replace("\\", "/");
        if (normalizedSource.startsWith("./")) {
            normalizedSource = normalizedSource.substring(2);
        }
        if (normalizedSource.startsWith("/")) {
            normalizedSource = normalizedSource.substring(1);
        }
        InputStream in = null;
        try {
            ZipEntry sourceEntry = this.zipFile.getEntry(normalizedSource);
            if (sourceEntry != null) {
                in = this.zipFile.getInputStream(sourceEntry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceNotFoundException("[ResourceLoader] Resource " + source + " not found in zip[" + this.zipFile.getName() + "]: " + e.getMessage());
        }
        if (in == null) {
            throw new ResourceNotFoundException("[ResourceLoader] Resource " + source + " not found in zip[" + this.zipFile.getName() + "].");
        }
        return in;
    }

    @Override
    public long lastModified(File file) {
        return 0L;
    }

    public String toString() {
        if (this.zipFile == null) {
            return "zipResourceFactory zip=[]";
        }
        return "zipResourceFactory zip=[" + this.zipFile.getName() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ZipResourceFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

