/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import pt.opensoft.io.ZipEntry;
import pt.opensoft.util.SystemParameters;

public class ZipInputStream
extends BufferedInputStream {
    public static final int FILE_BLOCK_SIZE = SystemParameters.FILE_BLOCK_SIZE;
    private final java.util.zip.ZipInputStream zin;
    private boolean gotNextEntry = false;
    private ZipEntry entry;

    public ZipInputStream(String name) throws IOException {
        this(new FileInputStream(name));
    }

    public ZipInputStream(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public ZipInputStream(InputStream in) throws IOException {
        this(new java.util.zip.ZipInputStream(new BufferedInputStream(in, FILE_BLOCK_SIZE)));
    }

    private ZipInputStream(java.util.zip.ZipInputStream zin) {
        super(zin, FILE_BLOCK_SIZE);
        this.zin = zin;
    }

    public boolean hasMoreEntries() throws IOException {
        if (!this.gotNextEntry) {
            java.util.zip.ZipEntry nextEntry = this.zin.getNextEntry();
            if (nextEntry == null) {
                return false;
            }
            this.entry = new ZipEntry(nextEntry);
            this.gotNextEntry = true;
        }
        return this.entry != null;
    }

    public ZipEntry nextEntry() throws IOException {
        if (!this.gotNextEntry) {
            this.entry = new ZipEntry(this.zin.getNextEntry());
        }
        this.gotNextEntry = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.zin.closeEntry();
    }
}

