/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import pt.opensoft.io.ProgressObserver;

public class ProgressInputStream
extends InputStream {
    protected InputStream in;
    protected ProgressObserver observer;
    protected long read = 0L;

    public ProgressInputStream(String filename, ProgressObserver observer) throws IOException {
        this(new File(filename), observer);
    }

    public ProgressInputStream(File file, ProgressObserver observer) throws IOException {
        this(new FileInputStream(file), observer);
    }

    public ProgressInputStream(InputStream in, ProgressObserver observer) throws IOException {
        this.in = in;
        this.observer = observer;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        if (i != -1) {
            this.notifyProgress(i);
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.notifyProgress(skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.notifyProgress(1L);
        }
        return b;
    }

    protected void notifyProgress(long i) {
        this.read += i;
        this.observer.setProgress(this.read);
    }
}

