/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadException;
import pt.opensoft.http.FileUpload;
import pt.opensoft.http.HttpRequestHeaderEnum;
import pt.opensoft.http.HttpSession;
import pt.opensoft.logger.Logger;
import pt.opensoft.msg.Request;
import pt.opensoft.msg.Session;
import pt.opensoft.util.ListUtil;

public class HttpRequest
extends Request {
    protected HttpServletRequest request = null;
    protected HttpSession session = null;

    public HttpRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public boolean containsValue(Object value) {
        List values = this.getValues();
        return values != null && values.contains(value) || super.containsValue(value);
    }

    public boolean containsName(String name) {
        String value = this.getParameter(name);
        return value != null || super.containsName(name);
    }

    public boolean getCheckBoxValue(String name) {
        return this.getBooleanValue(name, false, "on");
    }

    public boolean getCheckBoxValue(String name, boolean defaultValue) {
        return this.getBooleanValue(name, defaultValue, "on");
    }

    public List getNames() {
        List names = ListUtil.toList(this.request.getParameterNames());
        if (this.values == null) {
            return names;
        }
        return ListUtil.union(names, this.values.keys());
    }

    public Session getSession() {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        this.session = new HttpSession(this.request.getSession());
        return this.session;
    }

    public Session getSession(boolean create) {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        this.session = new HttpSession(this.request.getSession(create));
        return this.session;
    }

    public Object getValue(String name) {
        Object value = super.getValue(name);
        if (value == null) {
            value = this.request.getParameter(name);
        }
        if (value == null) {
            return null;
        }
        if (value.toString().trim().equals("")) {
            return null;
        }
        return value;
    }

    public List getValues(String name) {
        return this.getValues(name, null);
    }

    public List getValues(String name, List defaultValue) {
        Object values = this.getValue(name);
        if (values == null) {
            return defaultValue;
        }
        ArrayList list = new ArrayList();
        StringTokenizer st1 = new StringTokenizer((String)values, "+");
        while (st1.hasMoreTokens()) {
            String value1 = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(value1, ";", true);
            ArrayList<String> list2 = new ArrayList<String>();
            String last = null;
            while (st2.hasMoreTokens()) {
                String value2 = st2.nextToken();
                if (value2.equals(";")) {
                    if (last == null || last.equals(";")) {
                        list2.add("");
                        last = value2;
                        continue;
                    }
                    last = value2;
                    continue;
                }
                list2.add(value2);
                last = value2;
            }
            list.add(list2);
        }
        return list;
    }

    public Object setValue(String name, Object value) {
        return super.setValue(name, value);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Object getAttribute(String s) {
        return this.request.getAttribute(s);
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public boolean containsCookie(String name) {
        return this.getCookie(name) != null;
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public long getDateHeader(String s) {
        return this.request.getDateHeader(s);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getHeader(HttpRequestHeaderEnum header) {
        return this.getHeader(header.getHeaderName());
    }

    public String getHeader(String s) {
        return this.request.getHeader(s);
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public Enumeration getHeaders(String s) {
        return this.request.getHeaders(s);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public int getIntHeader(String s) {
        return this.request.getIntHeader(s);
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String s) {
        return this.request.getParameter(s);
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String[] getParameterValues(String s) {
        return this.request.getParameterValues(s);
    }

    public List getSelectedValues(String s) {
        return this.getSelectedValues(s, null);
    }

    public List getSelectedValues(String s, List defaultValues) {
        String[] values = this.request.getParameterValues(s);
        if (values == null) {
            return defaultValues;
        }
        return ListUtil.toList(this.request.getParameterValues(s));
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.request.getRequestDispatcher(s);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public void removeAttribute(String s) {
        this.request.getAttribute(s);
    }

    public boolean isUserInRole(String s) {
        return this.request.isUserInRole(s);
    }

    public void setAttribute(String s, Object o) {
        this.request.setAttribute(s, o);
    }

    public HttpSession getHttpSession() {
        return (HttpSession)this.getSession();
    }

    public boolean isUploadRequest() {
        return FileUpload.isUploadRequest(this.request);
    }

    public FileUpload getFileUpload(Logger logger, String tempDir, int maxUploadSize, int maxMemorySize) throws FileUploadException {
        if (this.isUploadRequest()) {
            FileUpload uploader = new FileUpload(logger, maxUploadSize, maxMemorySize, new File(tempDir));
            uploader.uploadWithException(this.request);
            return uploader;
        }
        logger.error((Object)"HTTPSERVLETREQUEST IS NOT AN UPLOAD REQUEST!");
        return null;
    }

    public String getRequestIpAddress() {
        String ipAddress = this.getHeader(HttpRequestHeaderEnum.X_CLIENT_IP);
        if (ipAddress == null && (ipAddress = this.getHeader(HttpRequestHeaderEnum.RLN_CLIENT_IP_ADDR)) == null && (ipAddress = this.getHeader(HttpRequestHeaderEnum.X_FORWARDED_FOR)) == null) {
            ipAddress = this.getRemoteAddr();
        }
        return ipAddress;
    }
}

