/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import pt.opensoft.field.ErrorHandler;
import pt.opensoft.field.MaxErrorsExceededException;
import pt.opensoft.field.ValidationException;

public class ListErrorHandler
implements ErrorHandler,
Comparator {
    protected Vector errors = new Vector();
    protected int maxErrors = 100;

    protected void addError(Object obj) {
        ValidationException error = (ValidationException)obj;
        this.errors.add(error);
        Collections.sort(this.errors, this);
        if (this.maxErrors > -1 && this.errors.size() + 1 > this.maxErrors) {
            MaxErrorsExceededException e = new MaxErrorsExceededException(this.errors.size() + 1, this.maxErrors, error.getLine(), error.getColumn());
            this.errors.add(e);
            throw e;
        }
    }

    public int compare(Object obj1, Object obj2) {
        ValidationException err1 = (ValidationException)obj1;
        ValidationException err2 = (ValidationException)obj2;
        if (err1.getLine() != err2.getLine()) {
            return err1.getLine() - err2.getLine();
        }
        return err1.getColumn() - err2.getColumn();
    }

    @Override
    public void clear() {
        this.errors.clear();
    }

    @Override
    public Object getError(int i) {
        return this.errors.get(i);
    }

    @Override
    public Vector getErrors() {
        return this.errors;
    }

    @Override
    public int getMaxErrrors() {
        return this.maxErrors;
    }

    @Override
    public void setMaxErrors(int max) {
        if (max < -1) {
            throw new IllegalArgumentException("max cannot be less than -1");
        }
        this.maxErrors = max;
    }

    @Override
    public void error(Object error) {
        this.addError(error);
    }
}

