/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import pt.opensoft.field.CheckDigit;

public class CheckDigitISO6346
extends CheckDigit {
    private static final int[] ISO_6346_MAP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38};

    public CheckDigitISO6346(int position) {
        super(1, position);
    }

    private static int charToISO6346(char c) {
        if (c >= '0' && c <= '9') {
            return ISO_6346_MAP[c - 48];
        }
        if (c >= 'A' && c <= 'Z') {
            return ISO_6346_MAP[c - 65 + 10];
        }
        return -1;
    }

    @Override
    public int calculate(String num) {
        return (int)CheckDigitISO6346.calculateControlDigitBinary(num);
    }

    private static long calculateControlDigitBinary(String str) {
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("Empty Str");
        }
        str = str.trim();
        long total = 0L;
        long multiplier = 1L;
        for (int pos = 0; pos < str.length(); ++pos) {
            int value = CheckDigitISO6346.charToISO6346(str.charAt(pos));
            if (value == -1) {
                throw new IllegalArgumentException("Unknown Char [" + str.charAt(pos) + "].");
            }
            total += multiplier * (long)value;
            multiplier *= 2L;
        }
        if ((total %= 11L) == 10L) {
            return 0L;
        }
        return total;
    }
}

