/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.enums;

public enum EfapiErrorEnum {
    UNKNOWN("Erro desconhecido.", -1),
    SUCCESS("Opera\u00e7\u00e3o efetuada com sucesso.", 0),
    FILE_NOT_EXISTS("Ficheiro local n\u00e3o existe.", 1),
    FILE_ALREADY_EXISTS_LOCAL("Ficheiro j\u00e1 existe na directoria local.", 2),
    FILE_ALREADY_EXISTS("Ficheiro j\u00e1 existe no servidor.", 3),
    INVALID_FILE_SIZE("Tamanho de ficheiro demasiado grande.", 4),
    INVALID_ARGS("Argumentos inv\u00e1lidos no comando indicado.", 5),
    UPLOAD_FAILED("Erro no upload do ficheiro.", 6),
    DOWNLOAD_FAILED("Erro no download do/s ficheiro/s.", 7),
    DELETE_LOCAL_FAILED("Erro ao tentar apagar ficheiro local.", 8),
    DELETE_REMOTE_FAILED("Erro ao tentar apagar ficheiro no servidor.", 9),
    UNAUTHENTICATED_USER("Utilizador n\u00e3o autenticado.", 10),
    UNAUTHORIZED_USER("Utilizador n\u00e3o tem os perfis necess\u00e1rios para efetuar opera\u00e7\u00f5es neste tipo de ficheiro.", 11),
    INVALID_OPERATION("Tipo de opera\u00e7\u00e3o inv\u00e1lida.", 12),
    INVALID_FILE_TYPE("Tipo de ficheiro indicado inv\u00e1lido", 13),
    SAVE_LOCAL_FILE_ERROR("Erro ao tentar gravar ficheiro local. Verifique se tem espa\u00e7o no disco ou se tem permiss\u00f5es para gravar o ficheiro no directoria indicada.", 14),
    SAVE_REMOTE_FILE_ERROR("Erro ao tentar gravar ficheiro no servidor. Poder\u00e1 haver pouco espa\u00e7o no disco do servidor.", 15),
    COMMUNICATION_ERROR("Erro de Comunica\u00e7\u00f5es. Verifique se n\u00e3o ter\u00e1 que definir os valores de proxy no ficheiro \"config.properties\" da Aplica\u00e7\u00e3o.", 16),
    INVALID_FILE_NAME_LENGTH("Nome do ficheiro cont\u00e9m caracteres inv\u00e1lidos ou tem demasiados carateres.", 18),
    REMOTE_UNAVAILABLE("Sistema de ficheiros remoto indispon\u00edvel ou path inv\u00e1lido", 17),
    INVALID_DIRECTORY("Directoria indicada \u00e9 inv\u00e1lida", 19),
    INVALID_JVM("Java Virtual Machine inv\u00e1lida", 20),
    TEMPORARILY_BLOCKED("Utilizador temporariamente bloqueado devido a demasiadas tentativas de login falhadas. Tente novamente mais tarde.", 21),
    WSAUTENTICA_COMMUNICATIONS_ERROR("Erro a comunicar com o WSAutentica. Caso o erro persistir, tente novamente mais tarde.", 22),
    WSPERFIS_COMMUNICATIONS_ERROR("Erro a comunicar com o WSPerfis. Caso o erro persistir, tente novamente mais tarde.", 23);

    private final String message;
    private final int errorCode;

    private EfapiErrorEnum(String message, int errorCode) {
        this.message = message;
        this.errorCode = errorCode;
    }

    public static EfapiErrorEnum getError(int codeError) {
        for (EfapiErrorEnum e : EfapiErrorEnum.values()) {
            if (e.getErrorCode() != codeError) continue;
            return e;
        }
        return UNKNOWN;
    }

    public String getMessage() {
        return this.message;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

