/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class SetUtil {
    public static Set toSet(String values) {
        return SetUtil.toSet(values, ",");
    }

    public static Set toSet(String values, String separator) {
        if (values == null) {
            return null;
        }
        if (values.trim().equals("")) {
            return new HashSet();
        }
        StringTokenizer tokenizer = new StringTokenizer(values, separator);
        HashSet<String> set = new HashSet<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreElements()) {
            String value = (String)tokenizer.nextElement();
            set.add(value.trim());
        }
        return set;
    }

    public static boolean intersects(Collection setA, Collection setB) {
        if (setA == null || setB == null) {
            return false;
        }
        for (Object o : setB) {
            if (!setA.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static String toString(Set set) {
        return SetUtil.toString(set, null);
    }

    public static String toString(Set set, String separator) {
        if (set == null) {
            return null;
        }
        if (separator == null) {
            separator = ";";
        }
        StringBuffer buffer = new StringBuffer();
        for (Object o : set) {
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            buffer.append(o != null ? o.toString() : "null");
        }
        return buffer.toString();
    }

    public static String toString(Set set, String separator, String delimiter) {
        if (set == null) {
            return null;
        }
        if (separator == null) {
            separator = ";";
        }
        StringBuffer buffer = new StringBuffer();
        for (Object o : set) {
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            if (delimiter != null) {
                buffer.append(delimiter);
            }
            buffer.append(o != null ? o.toString() : "null");
            if (delimiter == null) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private SetUtil() {
    }
}

