/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import pt.opensoft.io.ClasspathResourceFactory;
import pt.opensoft.io.ResourceNotFoundException;
import pt.opensoft.logger.Logger;
import pt.opensoft.util.StringUtil;

public class ResourceBundleWraper {
    protected static final Map<String, String> extraBundle = new HashMap<String, String>();
    private static Map<String, Map<String, ResourceBundle>> bundlesCache = new HashMap<String, Map<String, ResourceBundle>>();
    private static Map<String, String> nonExistentBundles = new HashMap<String, String>();
    private final String originalBundleName;
    private Map<String, ResourceBundle> bundlePool;

    public ResourceBundleWraper(ClassLoader bundleClassLoader, String bundleName, Locale locale) {
        this.originalBundleName = "/" + bundleName.replace('.', '/');
        if (nonExistentBundles.get(bundleName + "::" + locale) != null) {
            return;
        }
        if (bundlesCache.get(bundleName + "::" + locale) != null) {
            this.bundlePool = bundlesCache.get(bundleName + "::" + locale);
        } else {
            InputStream input;
            HashMap<String, ResourceBundle> bundlePoolTemp = new HashMap<String, ResourceBundle>();
            try {
                ClasspathResourceFactory loader = new ClasspathResourceFactory();
                input = loader.getResourceStream(this.originalBundleName + ".properties");
            }
            catch (ResourceNotFoundException e) {
                nonExistentBundles.put(bundleName + "::" + locale, bundleName + "::" + locale);
                return;
            }
            bundlePoolTemp.put(this.originalBundleName, ResourceBundle.getBundle(this.originalBundleName, locale, bundleClassLoader));
            try {
                this.handleIncludeDirectives(input, bundleClassLoader, locale, this.originalBundleName, bundlePoolTemp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bundlesCache.put(bundleName + "::" + locale, bundlePoolTemp);
            this.bundlePool = bundlePoolTemp;
        }
    }

    private void handleIncludeDirectives(InputStream input, ClassLoader bundleClassLoader, Locale locale, String originalBundleName, Map<String, ResourceBundle> bundlePool) throws IOException {
        if (input != null) {
            LineInputStream lineInput = new LineInputStream(input);
            String line = lineInput.readLine();
            while (!StringUtil.isEmpty(line) && line.startsWith("include(") && line.endsWith(")")) {
                String include = line.substring("include(".length(), line.lastIndexOf(")"));
                if (include == null) {
                    throw new RuntimeException("Resource bundle " + originalBundleName + " - Tag de include vazia");
                }
                bundlePool.put(include, ResourceBundle.getBundle(include, locale, bundleClassLoader));
                line = lineInput.readLine();
            }
        }
    }

    public String get(String key) {
        String value = null;
        if (this.bundlePool == null) {
            return null;
        }
        Set<String> bundleNames = this.bundlePool.keySet();
        for (String bundleName : bundleNames) {
            try {
                value = this.bundlePool.get(bundleName).getString(key);
                break;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        if (value == null) {
            value = extraBundle.get(key);
        }
        if (value == null) {
            Logger logger = Logger.getDefault().getWrapper();
            logger.push((Object)this.originalBundleName);
            logger.error((Object)("Could not find property " + key));
            return key;
        }
        return value;
    }
}

