/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.text.ParseException;
import java.util.regex.Pattern;
import pt.opensoft.util.MessageParameters;
import pt.opensoft.util.StringUtil;

public abstract class AbstractMessageParameters
implements MessageParameters {
    private static final String LINK_PATTERN = "\\{\\d\\d[^\\}]+\\}";
    private static final String START_LINK_PATTERN = "\\{\\d\\d";
    private static final String REPLACE_PATTERN = "\\|R\\|\\d\\d";
    private static final int COUNTER_LENGTH = 2;
    private static final String START_LINK = "{";
    private static final String END_LINK = "}";
    private static final String TAG_REPLACE = "|R|";

    @Override
    public String getMessageWithReplaces(String code, String[] replaces) {
        String message = this.getMessage(code);
        message = this.fillReplaces(message, replaces);
        return this.removeLinks(message);
    }

    @Override
    public String getMessageWithLinks(String code, String[] links) {
        String message = this.getMessage(code);
        message = this.fillLinks(message, links, code);
        return this.removeReplaces(message);
    }

    @Override
    public String getMessageWithReplacesAndLinks(String code, String[] replaces, String[] links) {
        String message = this.getMessage(code);
        message = this.fillReplaces(message, replaces);
        return this.fillLinks(message, links, code);
    }

    private String fillReplaces(String msg, String[] replaces) {
        if (replaces != null) {
            int msgIndex;
            while ((msgIndex = msg.indexOf(TAG_REPLACE)) != -1) {
                try {
                    int replaceIndex = Integer.parseInt(msg.substring(msgIndex + TAG_REPLACE.length(), msgIndex + TAG_REPLACE.length() + 2));
                    if (replaceIndex >= replaces.length) {
                        throw new RuntimeException(new ParseException("Falta de parametros para substituir os replaces \n\t\t" + msg, msgIndex));
                    }
                    msg = StringUtil.replaceFirst(msg, msg.substring(msgIndex, msgIndex + TAG_REPLACE.length() + 2), replaces[replaceIndex]);
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException(new ParseException("Mensagem no formato errado\n\t\t" + msg, msgIndex));
                }
            }
        }
        return msg;
    }

    private String fillLinks(String msg, String[] links, String errorCode) {
        if (links != null && links.length != 0) {
            int msgIndex;
            if (!Pattern.compile(LINK_PATTERN).matcher(msg).find()) {
                throw new RuntimeException("O erro " + errorCode + " est\u00e1 sintaticamente mal especificado.");
            }
            msg = StringUtil.replace(msg, END_LINK, "</a>");
            while ((msgIndex = msg.indexOf(START_LINK)) != -1) {
                try {
                    int lnkIndex = Integer.parseInt(msg.substring(msgIndex + START_LINK.length(), msgIndex + START_LINK.length() + 2));
                    if (lnkIndex >= links.length) {
                        throw new RuntimeException(new ParseException("Falta de parametros para substituir links \n\t\t" + msg, msgIndex));
                    }
                    msg = StringUtil.replaceFirst(msg, msg.substring(msgIndex, msgIndex + START_LINK.length() + 2), "<a href=\"" + links[lnkIndex] + "\">");
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException(new ParseException("Mensagem no formato errado\n\t\t" + msg, msgIndex));
                }
            }
        }
        return msg;
    }

    private String removeReplaces(String msg) {
        return msg.replaceAll(REPLACE_PATTERN, "");
    }

    private String removeLinks(String msg) {
        msg = msg.replaceAll(START_LINK_PATTERN, "");
        return StringUtil.replace(msg, END_LINK, "");
    }
}

