/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import pt.opensoft.io.ZipEntry;
import pt.opensoft.io.ZipInputStream;
import pt.opensoft.util.SystemParameters;

public class ZipReader
extends BufferedReader {
    public static final String DEFAULT_ENCODING = SystemParameters.DEFAULT_ENCODING;
    private final ZipInputStream zin;

    public ZipReader(String name) throws IOException {
        this(new ZipInputStream(name), DEFAULT_ENCODING);
    }

    public ZipReader(String name, String encoding) throws IOException {
        this(new ZipInputStream(name), encoding);
    }

    public ZipReader(File file) throws IOException {
        this(new ZipInputStream(file), DEFAULT_ENCODING);
    }

    public ZipReader(File file, String encoding) throws IOException {
        this(new ZipInputStream(file), encoding);
    }

    public ZipReader(InputStream in) throws IOException {
        this(new ZipInputStream(in), DEFAULT_ENCODING);
    }

    private ZipReader(ZipInputStream zin, String encoding) throws UnsupportedEncodingException {
        super(new InputStreamReader((InputStream)zin, encoding));
        this.zin = zin;
    }

    public boolean hasMoreEntries() throws IOException {
        return this.zin.hasMoreEntries();
    }

    public ZipEntry nextEntry() throws IOException {
        return this.zin.nextEntry();
    }

    public void closeEntry() throws IOException {
        this.zin.closeEntry();
    }
}

