/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import pt.opensoft.io.ResourceFactory;
import pt.opensoft.io.ResourceNotFoundException;

public class WarResourceFactory
implements ResourceFactory {
    protected ServletContext j2eeLoader;
    protected String prefix;

    public WarResourceFactory(ServletContext j2eeLoader, String prefix) {
        this.j2eeLoader = j2eeLoader;
        this.prefix = prefix;
    }

    @Override
    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        if (source.startsWith("./")) {
            source = source.substring(2);
        }
        InputStream in = null;
        if (!source.contains(":")) {
            try {
                if (this.prefix != null) {
                    source = this.prefix + source;
                }
                in = this.j2eeLoader.getResourceAsStream(source);
            }
            catch (Exception e) {
                throw new ResourceNotFoundException("[ResourceLoader] Resource " + source + " not found in war: " + e.getMessage());
            }
        }
        if (in == null) {
            throw new ResourceNotFoundException("[ResourceLoader] Resource " + source + " not found in war");
        }
        return in;
    }

    @Override
    public Set getResourcePaths(String path) throws ResourceNotFoundException {
        return this.j2eeLoader.getResourcePaths(path);
    }

    @Override
    public long lastModified(File file) {
        return 0L;
    }

    public String toString() {
        return "WarResourceFactory prefix=[" + this.prefix + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof WarResourceFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (this.j2eeLoader.toString() + this.toString()).hashCode();
    }
}

