/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.Reader;
import java.text.ParseException;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import pt.opensoft.io.DefaultFormatter;
import pt.opensoft.io.Formatter;
import pt.opensoft.io.VariableSizeReader;
import pt.opensoft.logger.Logger;
import pt.opensoft.util.ListHashMap;
import pt.opensoft.util.ListMap;

public class FLVParser {
    protected Element _spec;
    protected Formatter _formatter;

    public FLVParser(Element spec) {
        this._spec = spec;
        this._formatter = new DefaultFormatter();
    }

    public FLVParser(Element spec, Formatter formatter) {
        this._spec = spec;
        this._formatter = formatter;
    }

    public ListMap parse(Reader reader) throws ParseException {
        return this.parseAndFormatImpl(reader, false);
    }

    public ListMap parseAndFormat(Reader reader) throws ParseException {
        if (this._formatter == null) {
            throw new IllegalArgumentException("Formatter not defined.");
        }
        return this.parseAndFormatImpl(reader, true);
    }

    protected ListMap parseAndFormatImpl(Reader reader, boolean format) throws ParseException {
        VariableSizeReader varReader = new VariableSizeReader(reader);
        ListHashMap _list = new ListHashMap(256);
        List _fieldsList = this._spec.getChildren("field");
        int currentIdx = 0;
        for (Element _fieldSpec : _fieldsList) {
            String _name = _fieldSpec.getAttribute("name").getValue();
            Attribute _numEntriesAttr = _fieldSpec.getAttribute("numEntries");
            int _length = Integer.parseInt(_fieldSpec.getAttribute("length").getValue());
            if (_numEntriesAttr != null) {
                int _numEntries = Integer.parseInt(((String)_list.get(_numEntriesAttr.getValue())).trim());
                _length *= _numEntries;
            }
            String _type = _fieldSpec.getAttribute("type").getValue();
            String _field = null;
            try {
                _field = varReader.readString(_length);
            }
            catch (Exception e) {
                Logger.getDefault().debug((Object)this.getPrintedList(_list));
                throw new ParseException(e.getMessage() + " [field:" + _name + "]", currentIdx);
            }
            try {
                if (_type.equals("flag")) {
                    List _subFieldsList = _fieldSpec.getChildren("subField");
                    for (Element _subFieldSpec : _subFieldsList) {
                        String _subFieldName = _subFieldSpec.getAttribute("name").getValue();
                        this.putField(format, _list, _subFieldName, _field, _subFieldSpec);
                    }
                } else {
                    this.putField(format, _list, _name, _field, _fieldSpec);
                }
            }
            catch (Exception e) {
                Logger.getDefault().debug((Object)this.getPrintedList(_list));
                throw new ParseException(e + ": " + e.getMessage() + " [field:" + _name + "]", currentIdx);
            }
            currentIdx += _length;
        }
        return _list;
    }

    private void putField(boolean format, ListMap list, String name, String value, Element spec) throws Exception {
        if (format) {
            value = this._formatter.format(value, spec);
        }
        list.put(name, value);
    }

    private String getPrintedList(ListMap valores) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < valores.size(); ++i) {
            buffer.append((String)valores.getKey(i)).append(" = '").append((String)valores.getElement(i)).append("'\n");
        }
        return buffer.toString();
    }
}

