/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import pt.opensoft.http.HttpResponse;
import pt.opensoft.http.JavaHttpConnection;

public class JavaHttpsConnection
extends JavaHttpConnection {
    private String _algorithm;
    private String _sslProtocol;
    private String _ksPath;
    private String _ksPass;
    private String _keyStoreType;
    private String _tsPath = null;
    private String _tsPass = null;
    private String _trustStoreType;
    private String _debugMode;
    private boolean _requiresClientAutentication = false;
    private boolean _requiresServerAutentication = false;

    public JavaHttpsConnection(URL url) {
        super(url, false);
    }

    public void setAlgorithm(String algorithm) {
        this._algorithm = algorithm;
    }

    public void setSSLProtocol(String protocol) {
        this._sslProtocol = protocol;
    }

    public void setKeyStore(String ksAbsolutePath, String ksPassword, String ksType) {
        this._ksPath = ksAbsolutePath;
        this._ksPass = ksPassword;
        this._keyStoreType = ksType;
        this._requiresClientAutentication = true;
    }

    public void setTrustStore(String tsAbsolutePath, String tsPassword, String tsType) {
        this._tsPath = tsAbsolutePath;
        this._tsPass = tsPassword;
        this._trustStoreType = tsType;
        this._requiresServerAutentication = true;
    }

    public void setDebugMode(String debugMode) {
        this._debugMode = debugMode;
    }

    @Override
    protected JavaHttpConnection.JavaHttpConnectionThread getConnectionThread() {
        return new JavaHttpsConnectionThread();
    }

    private class JavaHttpsConnectionThread
    extends JavaHttpConnection.JavaHttpConnectionThread
    implements Runnable {
        KeyManagerFactory _kmf;
        TrustManagerFactory _tmf;

        public JavaHttpsConnectionThread() {
            super(JavaHttpsConnection.this);
            this._kmf = null;
            this._tmf = null;
        }

        private KeyStore getKeyStore(String ksPath, String ksPassword, String ksType) throws GeneralSecurityException, IOException {
            KeyStore ks = KeyStore.getInstance(ksType);
            ks.load(new FileInputStream(ksPath), ksPassword.toCharArray());
            return ks;
        }

        private void initKeyManagerFactory() throws GeneralSecurityException, IOException {
            if (JavaHttpsConnection.this._algorithm == null) {
                throw new RuntimeException("Tipo de algoritmo n\u00e3o especificado!");
            }
            if (JavaHttpsConnection.this._keyStoreType == null) {
                throw new RuntimeException("Tipo de KeyStore n\u00e3o especificado!");
            }
            KeyStore ks = this.getKeyStore(JavaHttpsConnection.this._ksPath, JavaHttpsConnection.this._ksPass, JavaHttpsConnection.this._keyStoreType);
            this._kmf = KeyManagerFactory.getInstance(JavaHttpsConnection.this._algorithm);
            this._kmf.init(ks, JavaHttpsConnection.this._ksPass.toCharArray());
        }

        private void initTrustManagerFactory() throws GeneralSecurityException, IOException {
            if (JavaHttpsConnection.this._algorithm == null) {
                throw new RuntimeException("Tipo de algoritmo n\u00e3o especificado!");
            }
            if (JavaHttpsConnection.this._trustStoreType == null) {
                throw new RuntimeException("Tipo de TrustStore n\u00e3o especificado!");
            }
            KeyStore ks = this.getKeyStore(JavaHttpsConnection.this._tsPath, JavaHttpsConnection.this._tsPass, JavaHttpsConnection.this._trustStoreType);
            this._tmf = TrustManagerFactory.getInstance(JavaHttpsConnection.this._algorithm);
            this._tmf.init(ks);
        }

        private SSLContext initSSLContext(KeyManager[] kms, TrustManager[] tms) throws GeneralSecurityException {
            if (JavaHttpsConnection.this._sslProtocol == null) {
                throw new RuntimeException("Protocolo de autentica\u00e7\u00e3o n\u00e3o foi definido!");
            }
            SSLContext ctx = SSLContext.getInstance(JavaHttpsConnection.this._sslProtocol);
            ctx.init(kms, tms, null);
            return ctx;
        }

        private void initSSLSocketFactory(KeyManager[] kms, TrustManager[] tms) throws GeneralSecurityException {
            SSLContext ctx = this.initSSLContext(kms, tms);
            SSLSocketFactory factory = ctx.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
        }

        @Override
        protected HttpURLConnection createHttpConnection(URL url) throws IOException {
            return (HttpURLConnection)url.openConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HttpResponse doHttpPost(URL url) throws IOException, GeneralSecurityException {
            if (JavaHttpsConnection.this._debugMode != null) {
                System.setProperty("javax.net.debug", JavaHttpsConnection.this._debugMode);
            }
            try {
                if (JavaHttpsConnection.this._requiresClientAutentication) {
                    this.initKeyManagerFactory();
                }
                if (JavaHttpsConnection.this._requiresServerAutentication) {
                    this.initTrustManagerFactory();
                }
                if (JavaHttpsConnection.this._requiresClientAutentication || JavaHttpsConnection.this._requiresServerAutentication) {
                    TrustManager[] trustManagerArray;
                    KeyManager[] kms;
                    KeyManager[] keyManagerArray = kms = this._kmf != null ? this._kmf.getKeyManagers() : null;
                    if (this._tmf != null) {
                        trustManagerArray = this._tmf.getTrustManagers();
                    } else {
                        TrustManager[] trustManagerArray2 = new TrustManager[1];
                        trustManagerArray = trustManagerArray2;
                        trustManagerArray2[0] = new PermissiveTrustManager();
                    }
                    TrustManager[] tms = trustManagerArray;
                    this.initSSLSocketFactory(kms, tms);
                }
                HttpResponse httpResponse = super.doHttpPost(url);
                return httpResponse;
            }
            finally {
                if (this.myConnection != null && !JavaHttpsConnection.this.isStreaming) {
                    this.disconnect();
                }
            }
        }

        private class PermissiveTrustManager
        implements X509TrustManager {
            private PermissiveTrustManager() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                System.out.println(">>> WARNING: NOT DOING CLIENT AUTENTICATION!!! <<<");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                System.out.println(">>> WARNING: NOT DOING SERVER AUTENTICATION!!! <<<");
            }

            public boolean isClientTrusted(X509Certificate[] cert) {
                return true;
            }

            public boolean isServerTrusted(X509Certificate[] cert) {
                return true;
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }
    }
}

