/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import pt.opensoft.http.ConnectionTimeoutException;
import pt.opensoft.http.Cookie;
import pt.opensoft.http.HttpConnection;
import pt.opensoft.http.HttpResponse;
import pt.opensoft.http.IHttpConnection;
import pt.opensoft.http.JavaHttpConnectionWithEncoding;
import pt.opensoft.logger.Level;
import pt.opensoft.logger.Logger;
import pt.opensoft.logger.Type;
import pt.opensoft.util.Pair;
import pt.opensoft.util.SystemParameters;
import pt.opensoft.util.Timer;

public class HttpConnectionWraper
implements IHttpConnection {
    private static final String NOT_DEFINED = "N/D";
    public static final String COMMONS_HTTP_CONNECTION = "pt.opensoft.http.HttpConnection";
    public static final String JAVA_HTTP_CONNECTION = "pt.opensoft.http.JavaHttpConnectionWithEncoding";
    public static final String DEFAULT_HTTP_CONNECTION = "pt.opensoft.http.HttpConnection";
    public static final String DEFAULT_ENCODING = SystemParameters.DEFAULT_ENCODING;
    private HttpConnection httpConnection;
    private JavaHttpConnectionWithEncoding javaHttpConnection;
    private final boolean isJavaHttpConnection;
    private int threshold;
    private final Logger logger;
    private final URL url;
    private boolean debug;
    private String user;
    private String application;

    public HttpConnectionWraper(URL url, String type) {
        this(url, type, false);
    }

    public HttpConnectionWraper(URL url, String type, String encoding, boolean streaming) {
        if ("pt.opensoft.http.HttpConnection".equals(type)) {
            this.httpConnection = new HttpConnection(url, streaming);
            this.isJavaHttpConnection = false;
        } else if (JAVA_HTTP_CONNECTION.equals(type)) {
            try {
                this.javaHttpConnection = new JavaHttpConnectionWithEncoding(url, encoding, streaming);
            }
            catch (UnsupportedEncodingException e) {
                try {
                    this.javaHttpConnection = new JavaHttpConnectionWithEncoding(url, DEFAULT_ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.isJavaHttpConnection = true;
        } else {
            throw new IllegalStateException("Unknown type '" + type + "'.");
        }
        this.threshold = 0;
        this.logger = Logger.getDefault().getWrapper();
        this.url = url;
        this.debug = false;
        this.user = NOT_DEFINED;
        this.application = NOT_DEFINED;
    }

    public HttpConnectionWraper(URL url, String type, boolean streaming) {
        this(url, type, DEFAULT_ENCODING, streaming);
    }

    public Logger getLogger() {
        throw new RuntimeException("HttpConnectionWrapper.getLogger() not implemented!");
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(int millis) {
        this.threshold = millis;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public void setApplication(String application) {
        this.application = application != null ? application : NOT_DEFINED;
    }

    public void setUser(String user) {
        this.user = user != null ? user : NOT_DEFINED;
    }

    @Override
    public void setHttp11(boolean http11) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.setHttp11(http11);
        } else {
            this.httpConnection.setHttp11(http11);
        }
    }

    @Override
    public void setMethod(int method) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.setMethod(method);
        } else {
            this.httpConnection.setMethod(method);
        }
    }

    @Override
    public void setTimeout(int millis) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.setTimeout(millis);
        } else {
            this.httpConnection.setTimeout(millis);
        }
    }

    @Override
    public void setProxy(String proxyName, int proxyPort) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.setProxy(proxyName, proxyPort);
        } else {
            this.httpConnection.setProxy(proxyName, proxyPort);
        }
    }

    @Override
    public void setResponseTimeout(int millis) {
        if (!this.isJavaHttpConnection) {
            this.httpConnection.setResponseTimeout(millis);
        }
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.isJavaHttpConnection) {
            throw new IllegalStateException("This instance needs to be of type 'COMMONS_HTTP_CONNECTION' to use this method.");
        }
        this.httpConnection.addCookie(cookie);
    }

    @Override
    public void addCookies(List cookies) {
        if (this.isJavaHttpConnection) {
            throw new IllegalStateException("This instance needs to be of type 'COMMONS_HTTP_CONNECTION' to use this method.");
        }
        this.httpConnection.addCookies(cookies);
    }

    @Override
    public void setProxyNTAuthentication(String domain, String userName, String password) throws UnknownHostException {
        if (this.isJavaHttpConnection) {
            throw new IllegalStateException("This instance needs to be of type 'COMMONS_HTTP_CONNECTION' to use this method.");
        }
        this.httpConnection.setProxyNTAuthentication(domain, userName, password);
    }

    public void setHostNTAuthentication(String domain, String userName, String password) throws UnknownHostException {
        if (this.isJavaHttpConnection) {
            throw new IllegalStateException("This instance needs to be of type 'COMMONS_HTTP_CONNECTION' to use this method.");
        }
    }

    public void setHostDigestAuthentication(String userName, String password) throws UnknownHostException {
        if (this.isJavaHttpConnection) {
            throw new IllegalStateException("This instance needs to be of type 'COMMONS_HTTP_CONNECTION' to use this method.");
        }
        this.httpConnection.setHostDigestAuthentication(userName, password);
    }

    @Override
    public void addParameter(String name, String value) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.addParameter(name, value);
        } else {
            this.httpConnection.addParameter(name, value);
        }
    }

    @Override
    public void addParameters(Map parameters) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.addParameters(parameters);
        } else {
            this.httpConnection.addParameters(parameters);
        }
    }

    @Override
    public void addRequestHeaders(Map requestHeaders) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.addRequestHeaders(requestHeaders);
        } else {
            this.httpConnection.addRequestHeaders(requestHeaders);
        }
    }

    @Override
    public void setRequestBody(byte[] body) {
        if (this.isJavaHttpConnection) {
            this.javaHttpConnection.setRequestBody(body);
        } else {
            this.httpConnection.setRequestBody(body);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpResponse send() throws IOException {
        boolean tooLong;
        this.logger.push("OBJID", (Object)"HttpConnection");
        HttpResponse response = null;
        IOException ex = null;
        Timer timer = new Timer();
        timer.start();
        boolean timeout = false;
        try {
            if (this.isDebug()) {
                this.logger.setLevel(Level.DEBUG);
            } else {
                this.logger.setLevel(Level.INFO);
            }
            this.logger.debug((Object)("BEFORE SEND " + timer.ellapsed() + " ms"));
            response = this.isJavaHttpConnection ? this.javaHttpConnection.send() : this.httpConnection.send();
            this.logger.debug((Object)("AFTER  SEND " + timer.ellapsed() + " ms"));
            this.logger.finer((Object)("RECEIVED    \n" + response));
            timer.stop();
        }
        catch (ConnectionTimeoutException e) {
            try {
                ex = e;
                throw e;
                catch (SocketTimeoutException e2) {
                    timeout = true;
                    ex = e2;
                    throw e2;
                }
                catch (InterruptedIOException e3) {
                    ex = e3;
                    throw e3;
                }
                catch (IOException e4) {
                    if (e4.getLocalizedMessage().equals("java.net.SocketTimeoutException: Read timed out")) {
                        timeout = true;
                        throw new SocketTimeoutException();
                    }
                    ex = e4;
                    throw e4;
                }
            }
            catch (Throwable throwable) {
                boolean tooLong2;
                timer.stop();
                Logger wrappedLog = this.logger.getWrapper();
                boolean bl = tooLong2 = this.threshold > 0 && timer.ellapsed() > (long)this.threshold;
                if (tooLong2) {
                    wrappedLog.push("longConnection", (Object)this.threshold);
                }
                if (timeout) {
                    wrappedLog.push("timedout", (Object)timeout);
                }
                if (ex != null && !timeout) {
                    wrappedLog.push("errorMessage", (Object)ex.getMessage());
                    wrappedLog.error(timer.ellapsed(), null);
                } else {
                    wrappedLog.push("user", (Object)this.user);
                    wrappedLog.push("application", (Object)this.application);
                    wrappedLog.push("url", (Object)this.url);
                    if (tooLong2 || timeout) {
                        wrappedLog.warning(Type.MONITOR, timer.ellapsed(), null);
                    } else {
                        wrappedLog.debug(Type.MONITOR, timer.ellapsed(), null);
                    }
                }
                this.logger.pop();
                throw throwable;
            }
        }
        Logger wrappedLog = this.logger.getWrapper();
        boolean bl = tooLong = this.threshold > 0 && timer.ellapsed() > (long)this.threshold;
        if (tooLong) {
            wrappedLog.push("longConnection", (Object)this.threshold);
        }
        if (timeout) {
            wrappedLog.push("timedout", (Object)timeout);
        }
        if (ex != null && !timeout) {
            wrappedLog.push("errorMessage", (Object)ex.getMessage());
            wrappedLog.error(timer.ellapsed(), null);
        } else {
            wrappedLog.push("user", (Object)this.user);
            wrappedLog.push("application", (Object)this.application);
            wrappedLog.push("url", (Object)this.url);
            if (tooLong || timeout) {
                wrappedLog.warning(Type.MONITOR, timer.ellapsed(), null);
            } else {
                wrappedLog.debug(Type.MONITOR, timer.ellapsed(), null);
            }
        }
        this.logger.pop();
        return response;
    }

    @Override
    public void setMultipartConnection(boolean value) {
        if (this.httpConnection != null) {
            this.httpConnection.setMultipartconnection(value);
        }
    }

    @Override
    public void setMultipartConnection(List<Pair<String, String>> textInputKeyValues, List<Pair<String, File>> keyFilePairs) throws FileNotFoundException {
        if (this.httpConnection != null) {
            this.httpConnection.setMultipartconnection(true);
            this.httpConnection.setMultipartconnectionParts(textInputKeyValues, keyFilePairs);
        }
    }
}

