/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import pt.opensoft.http.AbstractHttpConnection;
import pt.opensoft.http.ConnectionTimeoutException;
import pt.opensoft.http.Cookie;
import pt.opensoft.http.HttpResponse;
import pt.opensoft.util.ListHashMap;
import pt.opensoft.util.NameValue;
import pt.opensoft.util.Pair;

public class HttpConnection
extends AbstractHttpConnection {
    protected List _cookies = new ArrayList();
    protected Credentials _proxyCredentials;
    protected Credentials _hostCredentials;
    protected int _responseTimeout = 0;
    protected boolean _isStreaming;
    protected Map _requestAditionalHeaders;
    protected byte[] requestBody = null;
    private HttpMethodBase _methodObj;
    private List<Part> parts;
    protected boolean isMultipartConnection;

    public static void setLogWire(boolean logWire) {
        if (logWire) {
            System.setProperty("org.apache.commons.logging.Log", "pt.opensoft.http.HttpConnectionLogger");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "info");
        }
    }

    public HttpConnection(URL url) {
        this(url, false);
    }

    public HttpConnection(URL url, boolean isStreaming) {
        super(url);
        this._isStreaming = isStreaming;
        this._requestAditionalHeaders = new ListHashMap();
    }

    public void addCookie(Cookie cookie) {
        this._cookies.add(cookie.getInternalCookie());
    }

    public void addCookies(List cookies) {
        if (cookies != null) {
            Iterator iterator = cookies.iterator();
            while (iterator.hasNext()) {
                this.addCookie((Cookie)iterator.next());
            }
        }
    }

    public void addParameter(String name, String value) {
        this._parameters.add(new NameValuePair(name, value));
    }

    public void addParameters(Map parameters) {
        for (String name : parameters.keySet()) {
            this._parameters.add(new NameValuePair(name, (String)parameters.get(name)));
        }
    }

    public void addFilePartForMultipart(FilePart filePart) {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        this.parts.add((Part)filePart);
    }

    public void addRequestHeaders(Map requestHeaders) {
        if (requestHeaders == null) {
            return;
        }
        for (Object key : requestHeaders.keySet()) {
            this._requestAditionalHeaders.put(key, requestHeaders.get(key));
        }
    }

    public void setRequestBody(byte[] body) {
        this.requestBody = body;
    }

    public void setProxyNTAuthentication(String domain, String userName, String password) throws UnknownHostException {
        this._proxyCredentials = new NTCredentials(userName, password, HttpConnection.getLocalHostName(), domain);
    }

    public void setHostNTAuthentication(String domain, String userName, String password) throws UnknownHostException {
        this._hostCredentials = new NTCredentials(userName, password, HttpConnection.getLocalHostName(), domain);
    }

    public void setHostDigestAuthentication(String userName, String password) throws UnknownHostException {
        this._hostCredentials = new UsernamePasswordCredentials(userName, password);
    }

    public void setResponseTimeout(int timeout) {
        this._responseTimeout = timeout;
    }

    @Override
    public HttpResponse send() throws IOException {
        HttpClient client = new HttpClient();
        client.getParams().setConnectionManagerTimeout((long)this._timeout);
        client.getParams().setSoTimeout(this._responseTimeout);
        if (this._connectionTimeout > 0) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(this._connectionTimeout);
        }
        if (this._proxyName != null) {
            client.getHostConfiguration().setProxy(this._proxyName, this._proxyPort);
        }
        HttpState state = new HttpState();
        for (org.apache.commons.httpclient.Cookie cookie : this._cookies) {
            state.addCookie(cookie);
        }
        client.setState(state);
        if (this._proxyCredentials != null) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setProxyCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), this._proxyCredentials);
        }
        if (this._hostCredentials != null) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM), this._hostCredentials);
        }
        NameValuePair[] array = new NameValuePair[this._parameters.size()];
        int i = 0;
        Iterator iterator = this._parameters.iterator();
        while (iterator.hasNext()) {
            NameValuePair nameValuePair;
            array[i] = nameValuePair = (NameValuePair)iterator.next();
            ++i;
        }
        if (this.isMultipartConnection) {
            this.setMethodForMultipart(array);
            MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(this.buildPartsFromParameters(), ((PostMethod)this._methodObj).getParams());
            ((PostMethod)this._methodObj).setRequestEntity((RequestEntity)multipartRequestEntity);
        } else {
            this.setMethod(array);
        }
        this._methodObj.getParams().setVersion(HttpVersion.HTTP_1_1);
        Set headerKeys = this._requestAditionalHeaders.keySet();
        for (String propertyName : headerKeys) {
            String propertyValue = (String)this._requestAditionalHeaders.get(propertyName);
            this._methodObj.addRequestHeader(propertyName, propertyValue);
        }
        try {
            int status = client.executeMethod((HttpMethod)this._methodObj);
            org.apache.commons.httpclient.Cookie[] cookies = state.getCookies();
            ArrayList<Cookie> ourCookies = new ArrayList<Cookie>(cookies.length);
            for (int j = 0; j < cookies.length; ++j) {
                org.apache.commons.httpclient.Cookie cookie = cookies[j];
                ourCookies.add(new Cookie(cookie));
            }
            HttpResponse httpResponse = this.processResult(status, ourCookies);
            return httpResponse;
        }
        catch (ConnectTimeoutException e) {
            throw new ConnectionTimeoutException();
        }
        catch (HttpException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (!this._isStreaming) {
                this.disconnect();
            }
        }
    }

    private Part[] buildPartsFromParameters() {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        int partsLength = this.parts != null ? this.parts.size() : 0;
        Part[] partArray = new Part[partsLength + this._parameters.size()];
        int i = 0;
        for (NameValuePair param : this._parameters) {
            partArray[i] = new StringPart(param.getName(), param.getValue());
            ++i;
        }
        Iterator<Object> it = this.parts.iterator();
        while (it.hasNext()) {
            partArray[i] = (Part)it.next();
            ++i;
        }
        return partArray;
    }

    public void setMultipartconnectionParts(List<Pair<String, String>> textInputKeyValues, List<Pair<String, File>> keyFilePairs) throws FileNotFoundException {
        this.parts = new ArrayList<Part>(textInputKeyValues.size() + keyFilePairs.size());
        for (Pair<String, String> pair : textInputKeyValues) {
            this.parts.add((Part)new StringPart(pair.getFirst(), pair.getSecond()));
        }
        for (Pair<String, Object> pair : keyFilePairs) {
            this.parts.add((Part)new FilePart(pair.getFirst(), (File)pair.getSecond()));
        }
    }

    public void setMultipartconnection(boolean value) {
        this.isMultipartConnection = value;
    }

    private void setMethodForMultipart(NameValuePair[] array) {
        this._methodObj = new PostMethod(this._url.toString());
        ((PostMethod)this._methodObj).addParameters(array);
    }

    private void setMethod(NameValuePair[] array) {
        this._methodObj = null;
        switch (this._method) {
            case 1: {
                this._methodObj = new PostMethod(this._url.toString());
                ((PostMethod)this._methodObj).addParameters(array);
                if (this.requestBody == null) break;
                ((PostMethod)this._methodObj).setRequestBody(new String(this.requestBody));
                break;
            }
            case 2: {
                this._methodObj = new GetMethod(this._url.toString());
                this._methodObj.setQueryString(array);
            }
        }
    }

    public void disconnect() {
        if (this._methodObj != null) {
            this._methodObj.releaseConnection();
            this._methodObj = null;
        }
    }

    private HttpResponse processResult(int status, List ourCookies) throws IOException {
        if (HttpConnection.isRedirect(status)) {
            return this.processRedirect(status, this._methodObj);
        }
        return this.processResponse(status, ourCookies);
    }

    private Map getHeaders(HttpMethodBase methodObj) {
        Header[] headers = methodObj.getResponseHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (int j = 0; j < headers.length; ++j) {
            Header header = headers[j];
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    private HttpResponse processResponse(int status, List ourCookies) throws IOException {
        if (this._isStreaming) {
            return new HttpResponse(status, this._methodObj.getResponseBodyAsStream(), ourCookies, this.getHeaders(this._methodObj));
        }
        return new HttpResponse(status, this._methodObj.getResponseBodyAsString(), ourCookies, this.getHeaders(this._methodObj));
    }

    protected HttpResponse processRedirect(int status, HttpMethodBase originalRequest) throws IOException {
        Header locationHeader = originalRequest.getResponseHeader("location");
        if (locationHeader != null) {
            this.disconnect();
            if (status != 301 && status != 307) {
                this.setMethod(2);
            }
            if (originalRequest.getResponseHeader("Set-Cookie") != null) {
                Header newCookie = originalRequest.getResponseHeader("Set-Cookie");
                HeaderElement[] cookieElements = newCookie.getElements();
                for (int i = 0; i < cookieElements.length; ++i) {
                    HeaderElement cookieElement = cookieElements[i];
                    String name = cookieElement.getName();
                    String value = cookieElement.getValue();
                    String domain = null;
                    String path = null;
                    Date expires = null;
                    boolean secure = false;
                    NameValuePair[] params = cookieElement.getParameters();
                    for (int j = 0; params != null && j < params.length; ++j) {
                        NameValuePair param = params[j];
                        if (param.getName().equals("domain")) {
                            domain = param.getValue();
                            continue;
                        }
                        if (param.getName().equals("expires")) {
                            try {
                                expires = new SimpleDateFormat().parse(param.getValue());
                            }
                            catch (ParseException pe) {
                                System.err.println("Could not parse expires Set-Cookie parameter: " + param.getValue());
                            }
                            continue;
                        }
                        if (param.getName().equals("secure")) {
                            secure = true;
                            continue;
                        }
                        if (param.getName().equals("path")) {
                            path = param.getValue();
                            continue;
                        }
                        name = param.getName();
                        value = param.getValue();
                    }
                    this.addCookie(new Cookie(new org.apache.commons.httpclient.Cookie(domain, name, value, path, expires, secure)));
                }
            }
            this._url = new URL(locationHeader.getValue());
            if (this._url.getQuery() != null) {
                NameValue queryString = new NameValue(this._url.getQuery(), "&", "=");
                this._parameters.clear();
                for (int i = 0; i < queryString.elements().length; ++i) {
                    String queryParamName = queryString.elements()[i];
                    this.addParameter(queryParamName, queryString.getString(queryParamName));
                }
            }
            return this.send();
        }
        return new HttpResponse(500, "Internal Server Error", null, null);
    }

    public static boolean isRedirect(int status) {
        switch (status) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        HttpConnection.setLogWire(true);
        HttpConnection con = new HttpConnection(new URL("http://www.wikipedia.com/wiki/URL_redirection"));
        con.setHttp11(true);
        con.setProxy("proxy.ritta.local", 8080);
        con.setProxyNTAuthentication("dndgita", "opensoft01", "12345678o");
        HttpResponse res = con.send();
        System.out.println("res.getBody() = [" + res.getBody() + "]");
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        boolean first = true;
        for (NameValuePair parameter : this._parameters) {
            if (first) {
                buffer.append("?");
                first = false;
            } else {
                buffer.append("&");
            }
            buffer.append(parameter.getName()).append("=").append(parameter.getValue());
        }
        return buffer.toString();
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "pt.opensoft.http.HttpConnectionLogger");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "error");
    }
}

