/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import cec.taxud.fiscalis.vies.common.vat.CheckVat_AT;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_BE;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_BG;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_CY;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_CZ;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_DE;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_DK;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_EE;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_EL;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_ES;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_FI;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_FR;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_GB;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_HR;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_HU;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_IE;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_IT;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_LT;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_LU;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_LV;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_MT;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_NL;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_PL;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_PT;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_RO;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_SE;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_SI;
import cec.taxud.fiscalis.vies.common.vat.CheckVat_SK;
import cec.taxud.fiscalis.vies.common.vat.ValidationRoutine;
import java.util.HashMap;

public class EUNIFValidator {
    static final String NULVATSTRING = "0000000000000";
    public static final HashMap VALIDATORS = new HashMap();

    public static boolean testVatAt(String vat) {
        return EUNIFValidator.testCountryNif("AT", vat);
    }

    public static boolean testVatBe(String vat) {
        return EUNIFValidator.testCountryNif("BE", vat);
    }

    public static boolean testVatDe(String vat) {
        return EUNIFValidator.testCountryNif("DE", vat);
    }

    public static boolean testVatDk(String vat) {
        return EUNIFValidator.testCountryNif("DK", vat);
    }

    public static boolean testVatEl(String vat) {
        return EUNIFValidator.testCountryNif("EL", vat);
    }

    public static boolean testVatEs(String vat) {
        return EUNIFValidator.testCountryNif("ES", vat);
    }

    public static boolean testVatFi(String vat) {
        return EUNIFValidator.testCountryNif("FI", vat);
    }

    public static boolean testVatFr(String vat) {
        return EUNIFValidator.testCountryNif("FR", vat);
    }

    public static boolean testVatGb(String vat) {
        return EUNIFValidator.testCountryNif("GB", vat);
    }

    public static boolean testVatIe(String vat) {
        return EUNIFValidator.testCountryNif("IE", vat);
    }

    public static boolean testVatIt(String vat) {
        return EUNIFValidator.testCountryNif("IT", vat);
    }

    public static boolean testVatLu(String vat) {
        return EUNIFValidator.testCountryNif("LU", vat);
    }

    public static boolean testVatNl(String vat) {
        return EUNIFValidator.testCountryNif("NL", vat);
    }

    public static boolean testVatPt(String vat) {
        return EUNIFValidator.testCountryNif("PT", vat);
    }

    public static boolean testVatSe(String vat) {
        return EUNIFValidator.testCountryNif("SE", vat);
    }

    public static boolean testVatBg(String vat) {
        return EUNIFValidator.testCountryNif("BG", vat);
    }

    public static boolean testVatCy(String vat) {
        return EUNIFValidator.testCountryNif("CY", vat);
    }

    public static boolean testVatCz(String vat) {
        return EUNIFValidator.testCountryNif("CZ", vat);
    }

    public static boolean testVatEe(String vat) {
        return EUNIFValidator.testCountryNif("EE", vat);
    }

    public static boolean testVatHr(String vat) {
        return EUNIFValidator.testCountryNif("HR", vat);
    }

    public static boolean testVatHu(String vat) {
        return EUNIFValidator.testCountryNif("HU", vat);
    }

    public static boolean testVatLt(String vat) {
        return EUNIFValidator.testCountryNif("LT", vat);
    }

    public static boolean testVatLv(String vat) {
        return EUNIFValidator.testCountryNif("LV", vat);
    }

    public static boolean testVatMt(String vat) {
        return EUNIFValidator.testCountryNif("MT", vat);
    }

    public static boolean testVatPl(String vat) {
        return EUNIFValidator.testCountryNif("PL", vat);
    }

    public static boolean testVatRo(String vat) {
        return EUNIFValidator.testCountryNif("RO", vat);
    }

    public static boolean testVatSi(String vat) {
        return EUNIFValidator.testCountryNif("SI", vat);
    }

    public static boolean testVatSk(String vat) {
        return EUNIFValidator.testCountryNif("SK", vat);
    }

    private static boolean isNullVat(String vat) {
        if (vat == null) {
            return true;
        }
        return vat.length() == 0 || vat.regionMatches(0, NULVATSTRING, 0, vat.length());
    }

    public static boolean validate(String vat) {
        for (int i = 0; i < vat.length(); ++i) {
            String prefix = vat.substring(0, i);
            ValidationRoutine routine = (ValidationRoutine)VALIDATORS.get(prefix);
            if (routine == null) continue;
            return routine.check(vat.substring(i));
        }
        return false;
    }

    public static boolean testCountryNif(String country, String vat) {
        ValidationRoutine routine = (ValidationRoutine)VALIDATORS.get(country);
        if (routine == null) {
            return false;
        }
        return routine.check(vat);
    }

    static {
        VALIDATORS.put("AT", new CheckVat_AT());
        VALIDATORS.put("BE", new CheckVat_BE());
        VALIDATORS.put("DE", new CheckVat_DE());
        VALIDATORS.put("DK", new CheckVat_DK());
        VALIDATORS.put("GR", new CheckVat_EL());
        VALIDATORS.put("EL", VALIDATORS.get("GR"));
        VALIDATORS.put("ES", new CheckVat_ES());
        VALIDATORS.put("FI", new CheckVat_FI(){

            public boolean check(String vat) {
                if (EUNIFValidator.isNullVat(vat)) {
                    return false;
                }
                return super.check(vat);
            }
        });
        VALIDATORS.put("FR", new CheckVat_FR());
        VALIDATORS.put("GB", new CheckVat_GB());
        VALIDATORS.put("IE", new CheckVat_IE());
        VALIDATORS.put("IT", new CheckVat_IT());
        VALIDATORS.put("LU", new CheckVat_LU(){

            public boolean check(String vat) {
                if (EUNIFValidator.isNullVat(vat)) {
                    return false;
                }
                return super.check(vat);
            }
        });
        VALIDATORS.put("NL", new CheckVat_NL());
        VALIDATORS.put("PT", new CheckVat_PT());
        VALIDATORS.put("SE", new CheckVat_SE());
        VALIDATORS.put("BG", new CheckVat_BG(){

            public boolean check(String vat) {
                if (EUNIFValidator.isNullVat(vat)) {
                    return false;
                }
                return super.check(vat);
            }
        });
        VALIDATORS.put("CY", new CheckVat_CY());
        VALIDATORS.put("CZ", new CheckVat_CZ());
        VALIDATORS.put("EE", new CheckVat_EE());
        VALIDATORS.put("HR", new CheckVat_HR());
        VALIDATORS.put("HU", new CheckVat_HU());
        VALIDATORS.put("LT", new CheckVat_LT());
        VALIDATORS.put("LV", new CheckVat_LV());
        VALIDATORS.put("MT", new CheckVat_MT());
        VALIDATORS.put("PL", new CheckVat_PL());
        VALIDATORS.put("RO", new CheckVat_RO());
        VALIDATORS.put("SI", new CheckVat_SI());
        VALIDATORS.put("SK", new CheckVat_SK());
    }
}

