/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class LogUtils {
    public static final String OPERATION_RESULT = "operationResult";
    public static final String ERROR_CODE = "errorCode";
    public static final String ENDPOINT_URL = "serverUrl";
    public static final String FILENAME = "filename";
    public static final String SIZE = "size";
    public static final String NUMBER_OF_FILES = "numberOfFiles";
    public static final String FILES = "files";
    public static final String FILES_TO_DELETE = "filesToDelete";
    public static final String FILES_DELETED = "filesDeleted";
    public static final String FILES_NOT_DELETED = "filesNotDeleted";
    public static final String OPERATION_RESULT_OK = "OK";
    private static Map<String, String> logStack = new LinkedHashMap<String, String>();

    private LogUtils() {
    }

    public static void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        logStack.put(key, value);
    }

    private static void clear() {
        if (logStack == null || logStack.isEmpty()) {
            throw new IllegalStateException("logstack is null or already empty");
        }
        logStack.clear();
    }

    public static void getUploadFileTags(String filename, long length) {
        LogUtils.put(FILENAME, filename);
        LogUtils.put(SIZE, Long.toString(length));
    }

    public static String prepareLogStructure() {
        StringBuilder logText = new StringBuilder();
        Set<Map.Entry<String, String>> entrySet = logStack.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            logText.append(String.format("[%s] ", entry));
        }
        LogUtils.clear();
        return logText.toString();
    }

    public static void getErrorCodeAndResult(int status, String operationResult) {
        LogUtils.put(ERROR_CODE, Integer.toString(status));
        LogUtils.put(OPERATION_RESULT, operationResult);
    }
}

