/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.MissingResourceException;
import pt.at.efapi.Init;
import pt.at.efapi.service.ServiceConfiguration;
import pt.at.efapi.util.EfapiVersion;
import pt.opensoft.util.DateTime;
import pt.opensoft.util.Parameters;
import pt.opensoft.util.SystemParameters;

public final class EfapiLog {
    private static File logFile;
    private static final String LOG_DIR_PROPERTY = "log.dir";
    private static final String PATH_DELIMITER = "/";
    public static final String COPYRIGHT_AND_VERSION;

    private EfapiLog() {
    }

    private static File getLogFile() {
        try {
            File logDirectory = new File(LogConfiguration.getParameterFileProperties(LOG_DIR_PROPERTY, "logs"));
            if (!logDirectory.isDirectory() && !logDirectory.exists()) {
                logDirectory.mkdir();
            }
            if (logFile == null && !(logFile = new File(LogConfiguration.getFilename())).exists()) {
                logFile.createNewFile();
            }
            return logFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to create log file", e);
        }
    }

    private static void write(String s, long elapsedTime) {
        try {
            File file = EfapiLog.getLogFile();
            if (file != null && file.canWrite()) {
                FileWriter fileWriter = new FileWriter(file, true);
                fileWriter.write("[");
                fileWriter.write(String.valueOf(EfapiLog.getLevel()));
                fileWriter.write("] [");
                fileWriter.write(new DateTime().formatDateTime());
                fileWriter.write("] ");
                if (elapsedTime != 0L) {
                    fileWriter.write("[");
                    fileWriter.write(String.valueOf(elapsedTime));
                    fileWriter.write("] ");
                }
                fileWriter.write(s);
                fileWriter.write(SystemParameters.LINE_SEPARATOR);
                fileWriter.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to write to log file", e);
        }
    }

    public static void logToConsole(String text) {
        EfapiLog.logToConsole(text, 0L);
    }

    public static void logToConsole(String text, long elapsedTime) {
        StringBuilder logText = new StringBuilder();
        if (elapsedTime == 0L) {
            logText.append(String.format("[%s] ", new Timestamp(System.currentTimeMillis())));
        } else {
            logText.append(String.format("[%s] [%d] ", new Timestamp(System.currentTimeMillis()), elapsedTime));
        }
        logText.append(text);
        System.out.println(logText);
    }

    public static void logCopyrightAndAppVersionInConsole() {
        System.out.println(COPYRIGHT_AND_VERSION);
    }

    public static void writeLog(String text) {
        if (LogConfiguration.getLevel() == 1) {
            EfapiLog.write(text, 0L);
        }
    }

    public static void infoWriteLog(String text) {
        EfapiLog.infoWriteLog(text, 0L);
    }

    public static void infoWriteLog(String text, long elapsedTime) {
        if (LogConfiguration.getLevel() == 2) {
            EfapiLog.write(text, elapsedTime);
        }
    }

    public static int getLevel() {
        return LogConfiguration.getLevel();
    }

    public static void setLogfilename(String logFilename) {
        LogConfiguration.filename = logFilename;
    }

    static {
        COPYRIGHT_AND_VERSION = "\n(c) AT (v" + EfapiVersion.APP_VERSION + ") (" + EfapiVersion.APP_DATE + ")\n";
    }

    private static final class LogConfiguration {
        private static final String DEFAULT_FILENAME = "Efapi_log.txt";
        private static final int DEFAULT_LEVEL = 2;
        private static String filename;
        private static int level;

        private LogConfiguration() {
        }

        static String getFilename() {
            if (filename == null) {
                LogConfiguration.readFilename();
            }
            return filename;
        }

        private static void readFilename() {
            try {
                filename = LogConfiguration.getParameterFileProperties(EfapiLog.LOG_DIR_PROPERTY, System.getProperty("java.io.tmpdir")) + EfapiLog.PATH_DELIMITER + Init.getLogPrefix() + LogConfiguration.getParameterFileProperties("log.file", DEFAULT_FILENAME);
            }
            catch (MissingResourceException e) {
                filename = LogConfiguration.getParameterFileProperties(EfapiLog.LOG_DIR_PROPERTY, System.getProperty("java.io.tmpdir")) + EfapiLog.PATH_DELIMITER + Init.getLogPrefix() + DEFAULT_FILENAME;
            }
            EfapiLog.logToConsole("Logging to: " + filename);
        }

        static int getLevel() {
            if (level == -1) {
                LogConfiguration.readLevel();
            }
            return level;
        }

        private static void readLevel() {
            try {
                level = Integer.parseInt(LogConfiguration.getParameterFileProperties("log.level", "2"));
            }
            catch (MissingResourceException e) {
                level = 2;
            }
        }

        private static String getParameterFileProperties(String parameterName, String defaultValue) {
            Parameters parameters = Parameters.load(".", ServiceConfiguration.getEfapiConfigFileName());
            return parameters.getString(parameterName, defaultValue);
        }

        static {
            level = -1;
        }
    }
}

