/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.shell;

import org.apache.commons.cli.CommandLine;
import pt.at.efapi.exception.ConfigFileException;
import pt.at.efapi.exception.ServiceException;
import pt.at.efapi.shell.Action;
import pt.at.efapi.shell.DownloadAction;
import pt.at.efapi.shell.UploadAction;

public class Dispatcher {
    private static final String RECEBER = "receber";
    private static final String ENVIAR = "enviar";
    private static final int CODE_OK = 0;

    public int execute(CommandLine cmd) throws ServiceException, ConfigFileException {
        String command = cmd.getOptionValue("c");
        CommandDispatcher commandDispatcher = CommandDispatcher.getCommandDispatcher(command);
        commandDispatcher.getAction().execute(cmd);
        return 0;
    }

    public static enum CommandDispatcher {
        UPLOAD(1, "enviar", new UploadAction()),
        DOWNLOAD(2, "receber", new DownloadAction());

        private int type;
        private String descr;
        private Action action;

        private CommandDispatcher(int type, String descr, Action action) {
            this.type = type;
            this.descr = descr;
            this.action = action;
        }

        public int getType() {
            return this.type;
        }

        public String getDescr() {
            return this.descr;
        }

        public Action getAction() {
            return this.action;
        }

        public static boolean isValidType(String type) {
            return Dispatcher.ENVIAR.equals(type) || Dispatcher.RECEBER.equals(type);
        }

        public static CommandDispatcher getCommandDispatcher(String type) {
            if (Dispatcher.ENVIAR.equals(type)) {
                return UPLOAD;
            }
            if (Dispatcher.RECEBER.equals(type)) {
                return DOWNLOAD;
            }
            return null;
        }
    }
}

