/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.service;

import java.io.File;
import pt.at.efapi.enums.EfapiErrorEnum;
import pt.at.efapi.exception.LocalServiceException;
import pt.at.efapi.util.EfapiLog;

public class DeleteLocalFileService {
    public void run(String directory, String filename) throws LocalServiceException {
        if (directory == null || filename == null) {
            throw new IllegalArgumentException("Delete File Service invalid arguments");
        }
        File testDirectory = new File(directory);
        if (!testDirectory.isDirectory()) {
            EfapiLog.writeLog("LocalServiceException: the directory " + directory + " is invalid");
            throw new LocalServiceException(EfapiErrorEnum.INVALID_DIRECTORY);
        }
        File file = new File(directory, filename);
        if (!file.exists() || !file.isFile()) {
            EfapiLog.writeLog("LocalServiceException: the file " + filename + " is invalid");
            throw new LocalServiceException(EfapiErrorEnum.FILE_NOT_EXISTS);
        }
        try {
            if (!file.delete()) {
                EfapiLog.writeLog("LocalServiceException: the file " + filename + " cannot be deleted");
                throw new LocalServiceException(EfapiErrorEnum.DELETE_LOCAL_FAILED);
            }
        }
        catch (SecurityException e) {
            throw new LocalServiceException(EfapiErrorEnum.DELETE_LOCAL_FAILED, (Throwable)e);
        }
    }
}

