/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import pt.at.efapi.enums.EfapiErrorEnum;
import pt.at.efapi.exception.ConfigFileException;
import pt.at.efapi.exception.ServiceException;
import pt.at.efapi.shell.Dispatcher;
import pt.at.efapi.shell.Validator;
import pt.at.efapi.util.EfapiLog;
import pt.at.efapi.util.LogUtils;
import pt.opensoft.io.FileResourceFactory;
import pt.opensoft.io.ResourceLoader;

public class Init {
    public static final String MIN_JVM_VERSION = "1.6.0";
    private static String logPrefix = "";
    public static final String OPERATION_RESULT_ERROR = "ERROR";
    private static final String INVALID_ARGS_STRING = "\nErro na valida\u00e7\u00e3o dos argumentos. C\u00f3digo erro: ";
    private static final String INVALID_CHARS_IN_FILENAME = "#%&{}\\<>*?/$!'\":@+\u00b4`|=[];";
    private int status;
    private CommandLine commandLine;

    public Init() {
        ResourceLoader.addResourceFactory(new FileResourceFactory());
    }

    public static String getLogPrefix() {
        return logPrefix;
    }

    public int getStatus() {
        return this.status;
    }

    public static void main(String[] args) {
        int finalResult = Init.validateJavaVirtualMachine();
        if (finalResult == 0) {
            Init init = new Init();
            if (init.validate(args)) {
                init.execute();
            }
            EfapiLog.logToConsole(init.getStatus() + " - " + EfapiErrorEnum.getError(init.getStatus()).getMessage());
            finalResult = init.getStatus();
        }
        EfapiLog.logCopyrightAndAppVersionInConsole();
        System.exit(finalResult);
    }

    public boolean validate(String[] args) {
        Validator validator = new Validator();
        try {
            String filename;
            File file;
            this.logArguments(args);
            this.commandLine = validator.parse(args);
            if (!Dispatcher.CommandDispatcher.isValidType(this.commandLine.getOptionValue('c'))) {
                validator.usage();
                EfapiLog.writeLog(INVALID_ARGS_STRING + EfapiErrorEnum.INVALID_OPERATION.getErrorCode());
                this.status = EfapiErrorEnum.INVALID_OPERATION.getErrorCode();
                return false;
            }
            String directory = this.commandLine.getOptionValue("d");
            File testDirectory = new File(directory);
            if (!testDirectory.isDirectory()) {
                EfapiLog.infoWriteLog("The directory " + directory + " is invalid");
                EfapiLog.writeLog(INVALID_ARGS_STRING + (Object)((Object)EfapiErrorEnum.INVALID_DIRECTORY));
                this.status = EfapiErrorEnum.INVALID_DIRECTORY.getErrorCode();
                return false;
            }
            Dispatcher.CommandDispatcher commandDispatcher = Dispatcher.CommandDispatcher.getCommandDispatcher(this.commandLine.getOptionValue('c'));
            if (Dispatcher.CommandDispatcher.UPLOAD.equals((Object)commandDispatcher) && !this.isFileValid(file = new File(directory, filename = this.commandLine.getOptionValue("f")), filename)) {
                return false;
            }
        }
        catch (ParseException e) {
            validator.usage();
            EfapiLog.writeLog(INVALID_ARGS_STRING + EfapiErrorEnum.INVALID_ARGS.getErrorCode());
            this.status = EfapiErrorEnum.INVALID_ARGS.getErrorCode();
            return false;
        }
        return true;
    }

    private boolean isFileValid(File file, String filename) {
        if (StringUtils.containsAny((CharSequence)filename, (CharSequence)INVALID_CHARS_IN_FILENAME)) {
            EfapiLog.writeLog("Upload Service(validateFile): error validating filename of file " + file.getName() + " the filename contains invalid characters. \nDo not include in filename these set of characters: " + INVALID_CHARS_IN_FILENAME);
            this.status = EfapiErrorEnum.INVALID_FILE_NAME_LENGTH.getErrorCode();
            return false;
        }
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            EfapiLog.writeLog("Upload Service(validateFile): error validating file " + file.getName() + " the file was not found or can't be read");
            EfapiLog.writeLog(INVALID_ARGS_STRING + EfapiErrorEnum.FILE_NOT_EXISTS.getErrorCode());
            this.status = EfapiErrorEnum.FILE_NOT_EXISTS.getErrorCode();
            return false;
        }
        if (file.length() > 0x200000L) {
            EfapiLog.writeLog("Upload Service(validateFile): file " + file.getName() + " as an invalid size.");
            EfapiLog.writeLog(INVALID_ARGS_STRING + EfapiErrorEnum.INVALID_FILE_SIZE.getErrorCode());
            this.status = EfapiErrorEnum.INVALID_FILE_SIZE.getErrorCode();
            return false;
        }
        if (filename.length() > 246) {
            EfapiLog.writeLog("Upload Service(validateFile): error validating file " + file.getName() + " the file's name exceeds the maximum length allowed");
            EfapiLog.writeLog(INVALID_ARGS_STRING + EfapiErrorEnum.INVALID_FILE_NAME_LENGTH.getErrorCode());
            this.status = EfapiErrorEnum.INVALID_FILE_NAME_LENGTH.getErrorCode();
            return false;
        }
        return true;
    }

    private void logArguments(String[] args) {
        StringBuilder argumentos = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                ++i;
                continue;
            }
            argumentos.append(args[i]);
            argumentos.append(" ");
            if (!args[i].equals("-lp") || args.length <= i + 1) continue;
            logPrefix = args[i + 1];
        }
        EfapiLog.infoWriteLog("Invoking with arguments: " + argumentos.toString());
    }

    public void execute() {
        try {
            Dispatcher dispatcher = new Dispatcher();
            this.status = dispatcher.execute(this.commandLine);
        }
        catch (ServiceException e) {
            EfapiLog.infoWriteLog("ErrorCode: " + e.getError().getErrorCode() + " " + e.getError().getMessage());
            this.status = e.getError().getErrorCode();
            LogUtils.getErrorCodeAndResult(this.status, OPERATION_RESULT_ERROR);
            String logMessage = LogUtils.prepareLogStructure();
            EfapiLog.logToConsole(logMessage);
            EfapiLog.infoWriteLog(logMessage);
        }
        catch (ConfigFileException e) {
            this.status = -1;
            EfapiLog.logToConsole(e.getMessage());
        }
        finally {
            EfapiLog.infoWriteLog("Operation result:  " + this.status + "  (" + EfapiErrorEnum.getError(this.status).getMessage() + ")");
        }
    }

    private static int validateJavaVirtualMachine() {
        EfapiLog.logToConsole("Java home: " + System.getProperty("java.home"));
        String javaVersion = System.getProperty("java.version");
        EfapiLog.logToConsole("Java version: " + javaVersion);
        if (javaVersion.compareTo(MIN_JVM_VERSION) < 0) {
            EfapiLog.logToConsole(EfapiErrorEnum.INVALID_JVM.getErrorCode() + " - " + EfapiErrorEnum.INVALID_JVM.getMessage() + "\nPor favor indique durante o processo de instala\u00e7\u00e3o uma m\u00e1quina virtual java " + MIN_JVM_VERSION + ".");
            return EfapiErrorEnum.INVALID_JVM.getErrorCode();
        }
        return 0;
    }
}

