/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.Date;
import pt.opensoft.util.DateTime;

public class Quarter
extends DateTime {
    protected static final String[] QUARTER_NAMES_PT = new String[]{"1\u00ba Trimestre", "2\u00ba Trimestre", "3\u00ba Trimestre", "4\u00ba Trimestre"};

    public Quarter() {
    }

    public Quarter(Date date) {
        super(date);
    }

    public Quarter(int year, int quarter) {
        super(new DateTime(year, 3 * (quarter - 1), 1));
    }

    public static String getQuarterName(int quarter) {
        return QUARTER_NAMES_PT[quarter - 1];
    }

    public static String getQuarterShortName(int quarter) {
        return QUARTER_NAMES_PT[quarter - 1].substring(0, 6);
    }

    public DateTime getFirstDate() {
        int quarter = this.getMonth() / 3 + 1;
        int monthini = quarter * 3 - 3;
        return new DateTime(this.getYear(), monthini, 1, 0, 0, 0, 0);
    }

    public DateTime getLastDate() {
        int quarter = this.getQuarter();
        int monthend = quarter * 3;
        int year = this.getYear();
        if (monthend == 12) {
            ++year;
            monthend = 0;
        }
        return new DateTime(year, monthend, 1, 23, 59, 59, 999).addDays(-1);
    }

    public boolean contains(DateTime dateTime) {
        DateTime infDate = this.getFirstDate();
        DateTime supDate = this.getLastDate();
        return dateTime.equals(infDate) || dateTime.equals(supDate) || dateTime.after(infDate) && dateTime.before(supDate);
    }

    public int getQuarter() {
        return this.getMonth() / 3 + 1;
    }
}

