/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Cache
extends HashMap {
    private static final int DEFAULT_MAX_CAPACITY = 100;
    private int maxCapacity = 100;
    private final List keys;

    public Cache() {
        super(101, 1.0f);
        this.keys = new ArrayList(this.maxCapacity + 1);
    }

    public Cache(int maxCapacity) {
        super(maxCapacity + 1, 1.0f);
        this.maxCapacity = maxCapacity;
        this.keys = new ArrayList(maxCapacity + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.keys;
        synchronized (list) {
            super.clear();
            this.keys.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        List list = this.keys;
        synchronized (list) {
            if (this.containsKey(key)) {
                this.keys.remove(key);
            }
            super.put(key, value);
            this.keys.add(key);
            if (this.size() > this.maxCapacity) {
                return this.remove(this.keys.get(0));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        List list = this.keys;
        synchronized (list) {
            Object value = super.get(key);
            if (value == null) {
                return null;
            }
            this.keys.remove(key);
            this.keys.add(key);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        List list = this.keys;
        synchronized (list) {
            if (!this.containsKey(key)) {
                return null;
            }
            this.keys.remove(key);
            return super.remove(key);
        }
    }
}

