/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.List;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.StringUtil;

public class Address {
    private static final int ARTICLE_MAX_SIZE = 3;

    public static String compressNonNumeric(String name, int maxLength) {
        int i;
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength should be > 0, was: " + maxLength);
        }
        if (name.length() <= maxLength) {
            return name;
        }
        String separator = " ";
        if (name.indexOf(separator) == -1) {
            return name.substring(0, maxLength);
        }
        List subnames = ListUtil.toList(name, separator);
        int size = subnames.size();
        for (i = 1; i < size - 1 && StringUtil.length(subnames, separator) > maxLength; ++i) {
            String subname = (String)subnames.get(i);
            if (subname.length() <= 3 || StringUtil.isNumeric(subname)) continue;
            subnames.set(i, subname.substring(0, 1));
        }
        if (StringUtil.length(subnames, separator) <= maxLength) {
            return ListUtil.toString(subnames, separator);
        }
        for (i = 0; i < subnames.size() - 1 && StringUtil.length(subnames, separator) > maxLength; ++i) {
            subnames.remove(1);
        }
        if (StringUtil.length(subnames, separator) <= maxLength) {
            return ListUtil.toString(subnames, separator);
        }
        String firstName = (String)subnames.get(0);
        subnames.set(0, firstName.substring(0, 1));
        if (StringUtil.length(subnames, separator) <= maxLength) {
            return ListUtil.toString(subnames, separator);
        }
        subnames.remove(0);
        String lastName = (String)subnames.get(0);
        if (lastName.length() <= maxLength) {
            return lastName;
        }
        return lastName.substring(0, Math.min(maxLength, lastName.length()));
    }

    public static String compress(String name, int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength should be > 0, was: " + maxLength);
        }
        if (name.length() <= maxLength) {
            return name;
        }
        name = StringUtil.replace(name, "APARTAMENTO", "APT");
        name = StringUtil.replace(name, "AVENIDA", "AV");
        name = StringUtil.replace(name, "BAIRRO", "B");
        name = StringUtil.replace(name, "BLOCO", "BL");
        name = StringUtil.replace(name, "CONDOMINIO", "COND");
        name = StringUtil.replace(name, "CONJUNTO", "CONJ");
        name = StringUtil.replace(name, " DA ", " ");
        name = StringUtil.replace(name, " DAS ", " ");
        name = StringUtil.replace(name, " DE ", " ");
        name = StringUtil.replace(name, "DIREITO", "DIR");
        name = StringUtil.replace(name, " DO ", " ");
        name = StringUtil.replace(name, " DOS ", " ");
        name = StringUtil.replace(name, "EDIFICIO", "ED");
        name = StringUtil.replace(name, "ESQUERDO", "ESQ");
        name = StringUtil.replace(name, "ESTRADA", "ESTR");
        name = StringUtil.replace(name, "FRENTE", "FRT");
        name = StringUtil.replace(name, "HABITACIONAL", "HAB");
        name = StringUtil.replace(name, "LOTE", "L");
        name = StringUtil.replace(name, "PRACETA", "PCT");
        name = StringUtil.replace(name, "NUMERO", "N");
        name = StringUtil.replace(name, "QUINTA", "QT");
        name = StringUtil.replace(name, "RUA", "R");
        name = StringUtil.replace(name, "TRAVESSA", "TRV");
        name = StringUtil.replace(name, "URBANIZACAO", "URB");
        if ((name = StringUtil.replace(name, "VIVENDA", "VV")).length() > maxLength) {
            return Address.compressNonNumeric(name, maxLength);
        }
        return name;
    }
}

