/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import pt.opensoft.io.ZipEntry;
import pt.opensoft.util.SystemParameters;

public class ZipOutputStream
extends PrintStream {
    public static final int FILE_BLOCK_SIZE = SystemParameters.FILE_BLOCK_SIZE;
    private final java.util.zip.ZipOutputStream zos;
    private ZipEntry entry;

    public ZipOutputStream(String name) throws IOException {
        this(new FileOutputStream(name));
    }

    public ZipOutputStream(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public ZipOutputStream(OutputStream out) throws IOException {
        this(new java.util.zip.ZipOutputStream(new BufferedOutputStream(out, FILE_BLOCK_SIZE)));
    }

    private ZipOutputStream(java.util.zip.ZipOutputStream zos) {
        super(zos);
        this.zos = zos;
    }

    public ZipEntry newEntry(String name) throws IOException {
        return this.newEntry(name, true);
    }

    public ZipEntry newEntry(String name, boolean deflated) throws IOException {
        this.entry = new ZipEntry(name);
        this.entry.setMethod(deflated ? 8 : 0);
        this.zos.putNextEntry(this.entry);
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.flush();
        this.zos.closeEntry();
        this.entry = null;
    }
}

