/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class MultipleInputStream
extends InputStream {
    protected Vector streams = new Vector();
    protected Vector consumed = new Vector();
    protected InputStream current;

    public MultipleInputStream(InputStream in) {
        this.addInputStream(in);
        this.next();
    }

    public void addInputStream(InputStream in) {
        this.streams.addElement(in);
    }

    protected boolean hasNext() {
        return this.streams.size() > 0;
    }

    protected void next() {
        if (this.current != null) {
            this.consumed.addElement(this.current);
        }
        this.current = (InputStream)this.streams.firstElement();
        this.streams.removeElement(this.current);
    }

    @Override
    public int available() throws IOException {
        return this.current.available();
    }

    @Override
    public void close() throws IOException {
        InputStream in;
        int i;
        for (i = 0; i < this.consumed.size(); ++i) {
            in = (InputStream)this.consumed.elementAt(i);
            in.close();
        }
        this.current.close();
        for (i = 0; i < this.streams.size(); ++i) {
            in = (InputStream)this.streams.elementAt(i);
            in.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.current.markSupported();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.current.read(b, off, len);
        while (read == -1) {
            if (!this.hasNext()) {
                return read;
            }
            this.next();
            read = this.current.read(b, off, len);
        }
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.current.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        long total;
        long skipped = total = this.current.skip(n);
        while (skipped == -1L || total < n) {
            if (!this.hasNext()) {
                return total;
            }
            this.next();
            skipped = this.current.skip(n - total);
            total += skipped;
        }
        return total;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.read(buffer, 0, 1);
        if (read == -1) {
            return -1;
        }
        return buffer[0];
    }
}

