/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import pt.opensoft.util.SystemParameters;

public class MaxSizeOutputStream
extends BufferedOutputStream {
    private int maxSize = -1;
    private int wrote = 0;

    public MaxSizeOutputStream(OutputStream out, int maxSize) {
        super(out, SystemParameters.FILE_BLOCK_SIZE);
        if (maxSize <= 0) {
            throw new IllegalArgumentException("max size cannot be <= 0");
        }
        this.maxSize = maxSize;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.wrote + 1 > this.maxSize) {
            throw new IOException("tried to write more than " + this.maxSize + " bytes");
        }
        super.write(b);
        ++this.wrote;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.wrote + len > this.maxSize) {
            len = this.maxSize - this.wrote;
        }
        super.write(b, off, len);
        this.wrote += len;
        if (this.wrote + len > this.maxSize) {
            throw new IOException("tried to write more than " + this.maxSize + " bytes");
        }
    }
}

