/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import java.net.URL;
import pt.opensoft.field.StringField;

public class UrlField
extends StringField {
    public static boolean validate(String url) {
        if (url == null) {
            return false;
        }
        try {
            URL _url = new URL(url.trim().toLowerCase());
            return UrlField.validateUrlPart(_url.getHost());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean validateUrlPart(String urlPart) {
        if (urlPart == null) {
            return false;
        }
        int pos = urlPart.lastIndexOf(".");
        if (pos == -1 || pos == 0 || pos > urlPart.length() - 3) {
            return false;
        }
        char[] urlPartArray = urlPart.trim().toLowerCase().toCharArray();
        for (int i = 0; i < urlPartArray.length; ++i) {
            if (urlPartArray[i] >= 'a' && urlPartArray[i] <= 'z' || urlPartArray[i] >= '0' && urlPartArray[i] <= '9' || urlPartArray[i] == '.' || urlPartArray[i] == '-' || urlPartArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public UrlField(String name) {
        super(name);
    }
}

