/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import pt.opensoft.util.StringUtil;

public class RegistoPrivativoCTTValidator {
    private static final int[] WEIGHT = new int[]{7, 9, 5, 3, 2, 4, 6, 8};
    private static final int NUMERIC_PART_LENGTH = 8;

    public static int calculateCheckDigit(long num) {
        return RegistoPrivativoCTTValidator.calculateCheckDigit(String.valueOf(num));
    }

    public static int calculateCheckDigit(String num) {
        if (num.length() != 8) {
            throw new IllegalArgumentException("Invalid length: " + num);
        }
        if (!StringUtil.isNumeric(num)) {
            throw new NumberFormatException("Invalid number: " + num);
        }
        int sum = 0;
        for (int i = 0; i < 8; ++i) {
            int digit = num.charAt(8 - i - 1) - 48;
            sum += digit * WEIGHT[i];
        }
        int cd = sum % 11;
        if (cd == 0) {
            return 5;
        }
        if (cd == 1) {
            return 0;
        }
        return 11 - cd;
    }

    public static boolean validateCheckDigit(long num) {
        return RegistoPrivativoCTTValidator.validateCheckDigit(String.valueOf(num));
    }

    public static boolean validateCheckDigit(String num) {
        int digit;
        if (num.length() != 9) {
            return false;
        }
        if (!StringUtil.isNumeric(num)) {
            return false;
        }
        int cd = RegistoPrivativoCTTValidator.calculateCheckDigit(num.substring(0, 8));
        return cd == (digit = num.charAt(8) - 48);
    }
}

