/*
 * Decompiled with CFR 0.152.
 */
package pt.at.efapi.service;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import pt.at.efapi.enums.EfapiErrorEnum;
import pt.at.efapi.exception.ConfigFileException;
import pt.at.efapi.exception.RemoteServiceException;
import pt.at.efapi.service.RemoteService;
import pt.at.efapi.service.ServiceConfiguration;
import pt.at.efapi.service.UserDTO;
import pt.at.efapi.util.EfapiLog;
import pt.at.efapi.util.LogUtils;
import pt.opensoft.io.FileUtil;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.StringUtil;

public class DownloadService
extends RemoteService {
    private static final String OPERATION_DOWNLOAD = "efapiDownloadFiles";
    private String directory;
    private static final String DOWNLOAD_ENDPOINT = "/receberFicheiros";

    public List<String> run(UserDTO userDTO, String filetype, String directory) throws RemoteServiceException, ConfigFileException {
        if (userDTO == null || filetype == null || directory == null) {
            throw new IllegalArgumentException("Download Service illegal arguments");
        }
        long startTime = System.currentTimeMillis();
        File testDirectory = new File(directory);
        if (!testDirectory.isDirectory()) {
            EfapiLog.writeLog("DownloadServiceException: the directory " + directory + " is invalid");
            throw new RemoteServiceException(EfapiErrorEnum.INVALID_DIRECTORY);
        }
        try {
            this.directory = directory;
            this.init(new URL(ServiceConfiguration.getServerUrl() + DOWNLOAD_ENDPOINT));
            this.addUserParameters(userDTO);
            this.addOperationParameters(OPERATION_DOWNLOAD);
            this.addFiletypeParameter(filetype);
            EfapiLog.infoWriteLog("Requesting available files...");
        }
        catch (MalformedURLException e) {
            EfapiLog.writeLog("Download Service: Error setting the URL.");
            throw new RemoteServiceException(EfapiErrorEnum.COMMUNICATION_ERROR, (Throwable)e);
        }
        Document result = this.send();
        List<String> files = this.processDownloadResponse(result);
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        int size = files == null ? 0 : files.size();
        String filesString = files != null ? ListUtil.toString(files, ", ") : "";
        LogUtils.put("files", filesString);
        LogUtils.getErrorCodeAndResult(Integer.parseInt("0"), "OK");
        String logToPrint = LogUtils.prepareLogStructure();
        EfapiLog.logToConsole(logToPrint, elapsedTime);
        EfapiLog.infoWriteLog(logToPrint, elapsedTime);
        EfapiLog.infoWriteLog("Received " + size + " files" + (size == 0 ? "." : ": [ " + filesString + " ]"));
        return files;
    }

    private List<String> processDownloadResponse(Document document) throws RemoteServiceException {
        if (document == null || !document.hasRootElement()) {
            EfapiLog.writeLog("Download Service(processDownload): Answer is empty.");
            throw new RemoteServiceException(EfapiErrorEnum.DOWNLOAD_FAILED);
        }
        Element element = document.getRootElement();
        if (!element.getAttributeValue("error").equals("0")) {
            Integer codeError = Integer.valueOf(element.getAttributeValue("error"));
            EfapiLog.writeLog("Download Service(processDownload): Error code value " + codeError);
            throw new RemoteServiceException(EfapiErrorEnum.getError(codeError));
        }
        List<String> filesSaved = null;
        if (element.getAttributeValue("operation") == null || !element.getAttributeValue("operation").equals(OPERATION_DOWNLOAD)) {
            EfapiLog.writeLog("Download Service(processDownload): Answer is invalid.");
            throw new RemoteServiceException(EfapiErrorEnum.DOWNLOAD_FAILED);
        }
        filesSaved = this.saveFilesInDownloadResponse(element.getChildren());
        return filesSaved;
    }

    private boolean saveFile(String filename, String filecontent) throws IOException {
        File file = new File(this.directory, filename);
        if (!file.createNewFile()) {
            return false;
        }
        FileUtil.writeBinaryFile(file, StringUtil.toByteArray(filecontent));
        return true;
    }

    private List<String> saveFilesInDownloadResponse(List<Element> childrenElements) throws RemoteServiceException {
        ArrayList<String> filesSaved = new ArrayList<String>();
        LogUtils.put("numberOfFiles", Integer.toString(childrenElements.size()));
        if (childrenElements == null || childrenElements.isEmpty()) {
            return filesSaved;
        }
        Iterator<Element> iter = childrenElements.iterator();
        while (iter.hasNext()) {
            String filename = null;
            try {
                Element elem = iter.next();
                filename = DownloadService.decode(elem.getAttributeValue("filename"));
                String filecontent = DownloadService.unzip(DownloadService.decode(elem.getText()));
                if (!this.saveFile(filename, filecontent)) {
                    LogUtils.put("filename", filename);
                    EfapiLog.writeLog("Download Service(saveFiles): File " + filename + " already exists!");
                    throw new RemoteServiceException(EfapiErrorEnum.FILE_ALREADY_EXISTS_LOCAL);
                }
                filesSaved.add(filename);
            }
            catch (IOException e) {
                EfapiLog.writeLog("Download Service(saveFiles): File " + filename + " could not be saved!");
                throw new RemoteServiceException(EfapiErrorEnum.SAVE_LOCAL_FILE_ERROR, (Throwable)e);
            }
        }
        return filesSaved;
    }
}

