/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pt.opensoft.util.ArrayUtil;
import pt.opensoft.util.ByteUtil;
import pt.opensoft.util.StringUtil;

public class ZipUtil {
    protected static final int BUFFER_SIZE = 8192;

    public static String deflate(String text) throws IOException {
        return ByteUtil.toString(ZipUtil.deflate(StringUtil.toByteArray(text)));
    }

    public static byte[] deflate(byte[] bytes) throws IOException {
        return ZipUtil.deflate(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflate(byte[] bytes, int off, int len) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            DeflaterOutputStream zip = new DeflaterOutputStream(out);
            try {
                zip.write(bytes, off, len);
                zip.finish();
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                zip.close();
                throw throwable;
            }
            zip.close();
            return byArray;
        }
    }

    public static String inflate(String text) throws IOException {
        return ByteUtil.toString(ZipUtil.inflate(StringUtil.toByteArray(text)));
    }

    public static byte[] inflate(byte[] bytes) throws IOException {
        return ZipUtil.inflate(bytes, 0, bytes.length);
    }

    /*
     * Exception decompiling
     */
    public static byte[] inflate(byte[] bytes, int off, int len) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void retrieveFileFromZip(File zipDir, String zipFilename, String fileName, String outFileName) throws FileNotFoundException, IOException {
        FileOutputStream os;
        ZipInputStream in = new ZipInputStream(new FileInputStream(new File(zipDir, zipFilename)));
        ZipEntry zipEntry = in.getNextEntry();
        if (zipEntry.getName().equals(fileName)) {
            os = new FileOutputStream(new File(zipDir, outFileName));
            byte[] buf = new byte[1024];
            int qnt = 0;
            while ((qnt = in.read(buf)) > 0) {
                os.write(buf, 0, qnt);
            }
        } else {
            throw new IOException("Not found " + fileName + " in " + zipFilename);
        }
        in.close();
        os.close();
    }

    public static void getContentFromZip(InputStream in, OutputStream out) throws IOException {
        ZipUtil.getContentFromZip(in, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getContentFromZip(InputStream in, OutputStream out, String fileName) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(in);){
            int read;
            ZipEntry zipEntry = zin.getNextEntry();
            if (!StringUtil.isEmpty(fileName) && !zipEntry.getName().equalsIgnoreCase(fileName)) {
                throw new IOException("The name inside the zip file doesn't match the zip file.");
            }
            byte[] buf = new byte[8192];
            while ((read = zin.read(buf)) > 0) {
                out.write(buf, 0, read);
            }
            out.flush();
        }
    }

    public static boolean testZipFile(String filename) throws IOException {
        ZipFile file = new ZipFile(filename);
        return ZipUtil.testZipFile(file);
    }

    public static boolean testZipFile(ZipFile file) throws IOException {
        boolean fileOk = true;
        Enumeration<? extends ZipEntry> en = file.entries();
        while (fileOk && en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            fileOk = ZipUtil.testZipEntry(file, entry);
        }
        return fileOk;
    }

    public static boolean testZipEntry(ZipFile file, ZipEntry entry) throws IOException {
        int bytes;
        CRC32 check = new CRC32();
        long crc32 = entry.getCrc();
        InputStream in = file.getInputStream(entry);
        byte[] array = new byte[8192];
        while ((bytes = in.read(array, 0, 8192)) != -1) {
            check.update(array, 0, bytes);
        }
        return check.getValue() == crc32;
    }

    public static void listZipFile(String filename) throws IOException {
        ZipFile file = new ZipFile(filename);
        System.out.println("Zip file name: " + filename);
        Enumeration<? extends ZipEntry> en = file.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            System.out.println(entry.toString() + "\t" + (entry.getMethod() == 8 ? "deflated" : "stored") + "\t" + entry.getSize());
        }
    }

    public static void makeZipFile(String zipfilename, List filenames) throws IOException {
        ZipUtil.makeZipFile(zipfilename, null, filenames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeZipFile(String zipfilename, File dir, List filenames) throws IOException {
        if (filenames.size() == 0) {
            return;
        }
        File zipfile = dir != null ? new File(dir, zipfilename) : new File(zipfilename);
        try (FileOutputStream fos = new FileOutputStream(zipfile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.setMethod(8);
            for (String filename : filenames) {
                File file = dir != null ? new File(dir, filename) : new File(filename);
                ZipUtil.addFileToZip(zos, file);
            }
        }
    }

    public static void makeZipFile(String zipfilename, String filename) throws IOException {
        ZipUtil.makeZipFile(zipfilename, new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeZipFile(String zipfilename, File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipfilename);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.setMethod(8);
            ZipUtil.addFileToZip(zos, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToZip(ZipOutputStream zos, File f) throws IOException {
        try (FileInputStream fin = new FileInputStream(f);
             BufferedInputStream file = new BufferedInputStream(fin);){
            int bytes;
            ZipEntry entry = new ZipEntry(f.getName());
            entry.setMethod(8);
            zos.putNextEntry(entry);
            byte[] array = new byte[8192];
            while ((bytes = file.read(array, 0, 8192)) != -1) {
                zos.write(array, 0, bytes);
            }
            zos.closeEntry();
        }
    }

    public static String[] listAllFilesFromZip(ZipInputStream zipContent) {
        Vector<String> v = new Vector<String>();
        try {
            ZipEntry zipEntry = null;
            while ((zipEntry = zipContent.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                v.add(zipEntry.getName());
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                zipContent.close();
            }
            catch (Exception exception) {}
        }
        if (v.size() == 0) {
            return null;
        }
        return ArrayUtil.toStringArray(v);
    }

    public static String[] listAllFilesFromZip(InputStream zipContent) {
        return ZipUtil.listAllFilesFromZip(new ZipInputStream(zipContent));
    }

    private ZipUtil() {
    }
}

