/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.Date;
import pt.opensoft.util.DateTime;

public class Semester
extends DateTime {
    protected static final String[] SEMESTER_NAMES_PT = new String[]{"1\u00ba Semestre", "2\u00ba Semestre"};

    public Semester() {
    }

    public Semester(Date date) {
        super(date);
    }

    public Semester(int year, int semester) {
        super(new DateTime(year, 6 * (semester - 1), 1));
    }

    public static String getSemesterName(int semester) {
        return SEMESTER_NAMES_PT[semester - 1];
    }

    public static String getSemesterShortName(int semester) {
        return SEMESTER_NAMES_PT[semester - 1].substring(0, 6);
    }

    public DateTime getFirstDate() {
        int semester = this.getMonth() / 6 + 1;
        int monthini = semester * 6 - 6;
        return new DateTime(this.getYear(), monthini, 1, 0, 0, 0, 0);
    }

    public DateTime getLastDate() {
        int semester = this.getSemester();
        int monthend = semester * 6;
        int year = this.getYear();
        if (monthend == 12) {
            ++year;
            monthend = 0;
        }
        return new DateTime(year, monthend, 1, 23, 59, 59, 999).addDays(-1);
    }

    public boolean contains(DateTime dateTime) {
        DateTime infDate = this.getFirstDate();
        DateTime supDate = this.getLastDate();
        return dateTime.equals(infDate) || dateTime.equals(supDate) || dateTime.after(infDate) && dateTime.before(supDate);
    }

    public int getSemester() {
        return this.getMonth() / 6 + 1;
    }
}

