/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import java.io.FilenameFilter;
import pt.opensoft.text.Regex;

public class RegularExpressionFilenameFilter
implements FilenameFilter {
    protected Regex _regex = null;

    public RegularExpressionFilenameFilter() {
    }

    public RegularExpressionFilenameFilter(String regex) {
        this._regex = new Regex(regex);
    }

    public RegularExpressionFilenameFilter(String regex, int mask) {
        this._regex = new Regex(regex, mask);
    }

    @Override
    public boolean accept(File dir, String filename) {
        return this._regex.matches(filename);
    }

    public String toString() {
        return this._regex.toString();
    }

    public static void main(String[] args) {
        String dirname = args[0];
        String regex = args[1];
        File dir = new File(dirname);
        try {
            RegularExpressionFilenameFilter filter = new RegularExpressionFilenameFilter(regex, 1);
            String[] filenames = dir.list(filter);
            System.out.println("PROCESSING DIR: " + dir);
            for (int i = 0; i < filenames.length; ++i) {
                String filename = filenames[i];
                System.out.println("ACCEPTED FILE: " + filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

