/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import pt.opensoft.io.Formatter;
import pt.opensoft.math.BigNumber;
import pt.opensoft.util.DateTime;
import pt.opensoft.util.StringUtil;

public class DefaultFormatter
implements Formatter {
    private static final String EMPTY_STR = " ";
    private static final String EMPTY_DATE = "    -  -  ";
    private static final String DEFAULT_NULL_DATE = "0001-01-01";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String CHECK_TRUE_DEFAULT = "X";
    protected String space = " ";
    protected String emptyDate = "    -  -  ";

    protected void setSpace(String space) {
        this.space = space;
    }

    protected void setEmptyDate(String emptyDate) {
        this.emptyDate = emptyDate;
    }

    public String getEmpty() {
        return this.getEmpty(1);
    }

    public String getEmpty(int size) {
        if (size <= 0) {
            return "";
        }
        StringBuffer _str = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            _str.append(this.space);
        }
        return _str.toString();
    }

    public String booleanString(String str) {
        return this.booleanString(str, "V");
    }

    public String booleanString(String str, String trueValues) {
        if ("".equals(str)) {
            return this.space;
        }
        return trueValues.indexOf(str) != -1 ? CHECK_TRUE_DEFAULT : this.space;
    }

    @Override
    public String format(String str, Element spec) throws Exception {
        String _type = spec.getAttribute("type").getValue();
        if (_type.equals("text")) {
            String _suffix;
            String _nullValue = spec.getAttributeValue("nullValue");
            if (null != _nullValue && _nullValue.equals(str)) {
                str = EMPTY_STR;
            }
            if (null != (_suffix = spec.getAttributeValue("suffix")) && null != str && !str.trim().equals("")) {
                str = str + _suffix;
            }
            return this.format(str, _type);
        }
        if (_type.equals("date")) {
            String _nullDate;
            Attribute _nullDateAttr = spec.getAttribute("nullDate");
            String string = _nullDate = _nullDateAttr == null ? DEFAULT_NULL_DATE : _nullDateAttr.getValue();
            if (str.equals(_nullDate)) {
                return EMPTY_STR;
            }
            Attribute dateFormatSpec = spec.getAttribute("dateFormat");
            String dateFormat = dateFormatSpec == null ? DEFAULT_DATE_FORMAT : dateFormatSpec.getValue();
            DateTime data = null;
            try {
                data = new DateTime(str, dateFormat);
            }
            catch (Exception e) {
                return EMPTY_STR;
            }
            return data.formatDate();
        }
        if (_type.equals("amount")) {
            Attribute nullValueAttr = spec.getAttribute("nullValue");
            if (nullValueAttr != null && nullValueAttr.getValue().equals(str)) {
                return EMPTY_STR;
            }
            int _length = Integer.parseInt(spec.getAttribute("length").getValue());
            String strFormatted = this.getNumeric(str, _length, 2);
            String _suffix = spec.getAttributeValue("suffix");
            if (null != _suffix && null != strFormatted && !strFormatted.trim().equals("")) {
                strFormatted = strFormatted + _suffix;
            }
            return strFormatted;
        }
        if (_type.equals("number")) {
            int _length = Integer.parseInt(spec.getAttribute("length").getValue());
            Attribute precisionAtr = spec.getAttribute("precision");
            int _precision = 0;
            if (null != precisionAtr) {
                _precision = Integer.parseInt(precisionAtr.getValue());
            }
            String strFormatted = this.getNumeric(str, _length, _precision);
            String _suffix = spec.getAttributeValue("suffix");
            if (null != _suffix && null != strFormatted && !strFormatted.trim().equals("")) {
                strFormatted = strFormatted + _suffix;
            }
            return strFormatted;
        }
        if (_type.equals("integer")) {
            String _nullValue = spec.getAttributeValue("nullValue");
            if (null != _nullValue && _nullValue.equals(str)) {
                str = EMPTY_STR;
            }
            int _length = Integer.parseInt(spec.getAttribute("length").getValue());
            return this.getInteger(str, _length);
        }
        if (_type.equals("check")) {
            Attribute _checkTrue = spec.getAttribute("checkTrue");
            String _trueValue = _checkTrue != null ? _checkTrue.getValue() : CHECK_TRUE_DEFAULT;
            return this.booleanString(str, _trueValue);
        }
        if (_type.equals("code")) {
            List _decrs = spec.getChildren("textDescription");
            for (Element _descrSpec : _decrs) {
                if (!_descrSpec.getAttribute("name").getValue().equals(str)) continue;
                return StringUtil.replace(_descrSpec.getAttribute("value").getValue(), EMPTY_STR, this.space);
            }
            System.out.println("Invalid code in element " + spec.getAttributeValue("name") + ":>" + str + "<");
            return str;
        }
        if (_type.equals("nib")) {
            String _nullValue = spec.getAttributeValue("nullValue");
            if (null != _nullValue && _nullValue.equals(str)) {
                str = EMPTY_STR;
            }
            return this.format(str, _type);
        }
        throw new RuntimeException("Invalid type in formatter:" + _type);
    }

    @Override
    public String format(String str, String type) throws Exception {
        if (type.equals("text")) {
            return StringUtil.replace(str, EMPTY_STR, this.space);
        }
        if (type.equals("amount")) {
            int _length = str.length();
            return this.getNumeric(str, _length, 2);
        }
        if (type.equals("number")) {
            int _length = str.length();
            return this.getNumeric(str, _length, 0);
        }
        if (type.equals("integer")) {
            int _length = str.length();
            return this.getInteger(str, _length);
        }
        if (type.equals("check")) {
            return this.booleanString(str, CHECK_TRUE_DEFAULT);
        }
        if (type.equals("date")) {
            if (str.equals(DEFAULT_NULL_DATE)) {
                return this.emptyDate;
            }
        } else if (type.equals("nib")) {
            if (str.length() != 21) {
                return StringUtil.replace(str, EMPTY_STR, this.space);
            }
            return str.substring(0, 4) + "." + str.substring(4, 8) + "." + str.substring(8, 19) + "." + str.substring(19, 21);
        }
        return str;
    }

    @Override
    public String getNumeric(String str, int length, int precision) {
        if (str.trim().equals("")) {
            return this.getEmpty(length);
        }
        if (str.charAt(0) == '+') {
            str = str.substring(1);
        } else if (str.charAt(0) == '-') {
            str = "-" + str.substring(1).trim();
        }
        if (str.trim().equals("")) {
            return this.getEmpty(length);
        }
        BigNumber amount = new BigNumber(str.trim(), precision);
        return amount.format();
    }

    public String getInteger(String str, int length) {
        if (str.trim().equals("")) {
            return this.getEmpty(length);
        }
        if (str.charAt(0) == '+') {
            str = str.substring(1);
        } else if (str.charAt(0) == '-') {
            str = "-" + str.substring(1).trim();
        }
        if (str.trim().equals("")) {
            return this.getEmpty(length);
        }
        BigNumber amount = new BigNumber(str.trim(), 0);
        return amount.toString();
    }

    @Override
    public String getNumericFixedLength(String str, int length, int precision) {
        String numeric = this.getNumeric(str, length, precision);
        return this.getEmpty(length - numeric.length()) + numeric;
    }

    @Override
    public String getNumericNoFixedLength(String str, int length, int precision) {
        if (str.trim().equals("")) {
            return "";
        }
        return this.getNumeric(str, length, precision);
    }
}

