/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import pt.opensoft.http.JavaHttpConnection;

public class JavaHttpConnectionWithEncoding
extends JavaHttpConnection {
    private String encode;

    public JavaHttpConnectionWithEncoding(URL url, String encode) throws UnsupportedEncodingException {
        this(url, encode, false);
    }

    public JavaHttpConnectionWithEncoding(URL url, String encode, boolean isStreaming) throws UnsupportedEncodingException {
        super(url, isStreaming);
        this.setEncoding(encode);
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (!Charset.isSupported(encoding)) {
            throw new UnsupportedEncodingException("Unsupported encode : " + encoding);
        }
        this.encode = encoding;
    }

    public String getEncode() {
        return this.encode;
    }

    @Override
    protected void sendHttpPost(URLConnection connection) throws IOException {
        String outputString = this.constructOutputString();
        OutputStream outputStream = connection.getOutputStream();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(outputStream, this.getEncode()));
            writer.print(outputString);
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.toString());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            outputStream.close();
        }
    }
}

