/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import java.util.List;
import pt.opensoft.field.EuroField;
import pt.opensoft.msg.Request;
import pt.opensoft.msg.ValidateException;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.StringUtil;

public class RequestValidator {
    protected Request _request;

    public RequestValidator(Request request) {
        this._request = request;
    }

    public void checkNull(String fieldName, String fieldDescription) throws ValidateException {
        if (this._request.getString(fieldName) == null || this._request.getString(fieldName).length() == 0) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " tem que estar preenchido.");
        }
    }

    public void checkMinLength(String fieldName, String fieldDescription, int size) {
        if (this._request.getString(fieldName) != null && this._request.getString(fieldName).length() < size) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " deve ter pelo menos " + size + " carateres.");
        }
    }

    public void checkMaxLength(String fieldName, String fieldDescription, int size) {
        if (this._request.getString(fieldName) != null && this._request.getString(fieldName).length() > size) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " n\u00e3o pode exceder " + size + " carateres.");
        }
    }

    public void checkNumeric(String fieldName, String fieldDescription) {
        if (this._request.getString(fieldName) != null && !StringUtil.isNumeric(this._request.getString(fieldName))) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " tem que ser num\u00e9rico.");
        }
    }

    public void checkMinValue(String fieldName, String fieldDescription, int minValue) {
        if (this._request.getString(fieldName) != null && this._request.getInt(fieldName) < minValue) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " deve ser maior ou igual a " + minValue + ".");
        }
    }

    public void checkMaxValue(String fieldName, String fieldDescription, int maxValue) {
        if (this._request.getString(fieldName) != null && this._request.getInt(fieldName) > maxValue) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " deve ser menor ou igual a " + maxValue + ".");
        }
    }

    public void checkPossibleValues(String fieldName, String fieldDescription, String possibleValues) {
        List possibleValuesList = ListUtil.toList(possibleValues, ",");
        if (this._request.getString(fieldName) != null && !possibleValuesList.contains(this._request.getString(fieldName))) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " deve corresponder a um destes valores: " + possibleValues + ".");
        }
    }

    public void checkEuro(String fieldName, String fieldDescription) {
        if (this._request.getString(fieldName) != null && !EuroField.isValid(this._request.getString(fieldName))) {
            throw new ValidateException(fieldName, "O campo " + fieldDescription + " deve conter um valor v\u00e1lido em euros.");
        }
    }
}

