/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import pt.opensoft.io.ResourceLoader;
import pt.opensoft.logger.Logger;
import pt.opensoft.util.ClassUtil;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.SystemParameters;
import pt.opensoft.util.Transformer;

public class XmlUtil {
    public static final String CRIMSON_SAX_PARSER = "org.apache.crimson.parser.XMLReaderImpl";
    public static final String XERCES_SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String DEFAULT_INDENT = "  ";
    public static final String DEFAULT_ENCODING = SystemParameters.DEFAULT_ENCODING;
    private static final Map<Integer, String> mappings = XmlUtil.fillMappings();

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        XmlUtil.protectParserFactoryFromXXE(spf);
        return spf;
    }

    public static SAXParserFactory getSAXParserFactory(String factoryClassName, ClassLoader classLoader) {
        SAXParserFactory spf = SAXParserFactory.newInstance(factoryClassName, classLoader);
        XmlUtil.protectParserFactoryFromXXE(spf);
        return spf;
    }

    public static SAXBuilder getSAXBuilder() {
        FeatureValidatingSAXBuilder saxBuilder = new FeatureValidatingSAXBuilder();
        XmlUtil.protectParserFromXXE(saxBuilder);
        return saxBuilder;
    }

    public static SAXBuilder getSAXBuilder(String saxDriverClass) {
        FeatureValidatingSAXBuilder saxBuilder = new FeatureValidatingSAXBuilder(saxDriverClass);
        XmlUtil.protectParserFromXXE(saxBuilder);
        return saxBuilder;
    }

    public static SAXBuilder getSAXBuilder(boolean validate) {
        FeatureValidatingSAXBuilder saxBuilder = new FeatureValidatingSAXBuilder(validate);
        XmlUtil.protectParserFromXXE(saxBuilder);
        return saxBuilder;
    }

    public static SAXBuilder getSAXBuilder(String saxDriverClass, boolean validate) {
        FeatureValidatingSAXBuilder builder = new FeatureValidatingSAXBuilder(saxDriverClass, validate);
        XmlUtil.protectParserFromXXE(builder);
        return builder;
    }

    public static SAXParser getXercesSAXParser() {
        SAXParser saxParser = new SAXParser();
        XmlUtil.protectParserFromXXE(saxParser);
        return saxParser;
    }

    public static SAXParser getXercesSAXParser(XMLParserConfiguration config) {
        SAXParser saxParser = new SAXParser(config);
        XmlUtil.protectParserFromXXE(saxParser);
        return saxParser;
    }

    public static SAXParser getXercesSAXParser(SymbolTable symbolTable) {
        SAXParser saxParser = new SAXParser(symbolTable);
        XmlUtil.protectParserFromXXE(saxParser);
        return saxParser;
    }

    public static SAXParser getXercesSAXParser(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        SAXParser saxParser = new SAXParser(symbolTable, grammarPool);
        XmlUtil.protectParserFromXXE(saxParser);
        return saxParser;
    }

    public static XMLReader getSaxParser(String parserName) {
        try {
            Class<?> parserClass = Class.forName(parserName);
            XMLReader xmlReader = (XMLReader)ClassUtil.newInstance(parserClass);
            XmlUtil.protectParserFromXXE(xmlReader);
            return xmlReader;
        }
        catch (ClassNotFoundException e) {
            Logger.getDefault().warning((Object)(parserName + " not found. Continuing with default org.apache.xerces.parsers.SAXParser."));
            return XmlUtil.getXercesSAXParser();
        }
    }

    public static void protectParserFromXXE(XMLReader saxParser) {
        try {
            try {
                if (System.getProperty("http://apache.org/xml/features/disallow-doctype-decl") != null) {
                    saxParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.parseBoolean(System.getProperty("http://apache.org/xml/features/disallow-doctype-decl")));
                }
            }
            catch (AccessControlException e) {
                Logger.getDefault().warning((Object)"Nao foi possivel efetuar a leitura da propriedade 'http://apache.org/xml/features/disallow-doctype-decl'. Default 'true'", (Throwable)e);
                saxParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            saxParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        try {
            saxParser.setFeature("http://apache.org/xml/features/xinclude", false);
        }
        catch (SAXNotRecognizedException e) {
            Logger.getDefault().info((Object)("While setting parser feature \"http://apache.org/xml/features/xinclude\", got exception: " + e.getMessage() + ". Ignoring it!"));
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void protectParserFromXXE(SAXBuilder saxBuilder) {
        try {
            if (System.getProperty("http://apache.org/xml/features/disallow-doctype-decl") != null) {
                saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.parseBoolean(System.getProperty("http://apache.org/xml/features/disallow-doctype-decl")));
            }
        }
        catch (AccessControlException e) {
            Logger.getDefault().warning((Object)"Nao foi possivel efetuar a leitura da propriedade 'http://apache.org/xml/features/disallow-doctype-decl'. Default 'true'", (Throwable)e);
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxBuilder.setExpandEntities(false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxBuilder.setFeature("http://apache.org/xml/features/xinclude", false);
    }

    public static void protectParserFactoryFromXXE(SAXParserFactory spf) {
        try {
            try {
                if (System.getProperty("http://apache.org/xml/features/disallow-doctype-decl") != null) {
                    spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.parseBoolean(System.getProperty("http://apache.org/xml/features/disallow-doctype-decl")));
                }
            }
            catch (AccessControlException e) {
                Logger.getDefault().warning((Object)"Nao foi possivel efetuar a leitura da propriedade 'http://apache.org/xml/features/disallow-doctype-decl'. Default 'true'", (Throwable)e);
                spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        try {
            spf.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException e) {
            Logger.getDefault().info((Object)("While setting property XIncludeAware(false) got exception: " + e.getMessage() + ". Trying the equivalent feature."));
        }
        try {
            spf.setFeature("http://apache.org/xml/features/xinclude", false);
        }
        catch (SAXNotRecognizedException e) {
            Logger.getDefault().info((Object)("While setting parser feature \"http://apache.org/xml/features/xinclude\", got exception: " + e.getMessage() + ". Ignoring it!"));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document readXml(File file) throws Exception {
        try (InputStream in = ResourceLoader.getResourceStream(file);){
            Document document = XmlUtil.readXml(in);
            return document;
        }
    }

    public static Document readXml(InputStream in) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(in, DEFAULT_ENCODING);){
            Document document = XmlUtil.readXml(reader);
            return document;
        }
    }

    public static Document readXml(Reader reader) throws Exception {
        return XmlUtil.getSAXBuilder().build(reader);
    }

    public static String toString(Document document) {
        return XmlUtil.toString(document, DEFAULT_INDENT, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Document document, String indent, boolean newLines) {
        StringWriter writer = new StringWriter();
        try {
            try {
                XmlUtil.writeTo(document, (Writer)writer, indent, newLines);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static String toString(Element element) {
        return XmlUtil.toString(element, DEFAULT_INDENT, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Element element, String indent, boolean newLines) {
        StringWriter writer = new StringWriter();
        try {
            try {
                XmlUtil.writeTo(element, (Writer)writer, indent, newLines);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static void writeTo(Element element, OutputStream out) throws IOException {
        XmlUtil.writeTo(element, (Writer)new OutputStreamWriter(out, DEFAULT_ENCODING), DEFAULT_INDENT, true);
    }

    public static void writeTo(Element element, OutputStream out, String indent, boolean newLines) throws IOException {
        XmlUtil.writeTo(element, (Writer)new OutputStreamWriter(out, DEFAULT_ENCODING), indent, newLines);
    }

    public static void writeTo(Element element, Writer writer) throws IOException {
        XmlUtil.writeTo(element, writer, DEFAULT_INDENT, true);
    }

    public static void writeTo(Element element, Writer writer, String indent, boolean newLines) throws IOException {
        XMLOutputter out = new XMLOutputter(indent, newLines);
        out.output(element, writer);
    }

    public static void writeTo(Document document, OutputStream out) throws IOException {
        XmlUtil.writeTo(document, (Writer)new OutputStreamWriter(out, DEFAULT_ENCODING));
    }

    public static void writeTo(Document document, OutputStream out, String indent, boolean newLines) throws IOException {
        XmlUtil.writeTo(document, (Writer)new OutputStreamWriter(out, DEFAULT_ENCODING), indent, newLines);
    }

    public static void writeTo(Document document, Writer writer) throws IOException {
        XmlUtil.writeTo(document, writer, DEFAULT_INDENT, true);
    }

    public static void writeTo(Document document, Writer writer, String indent, boolean newLines) throws IOException {
        XMLOutputter out = new XMLOutputter(indent, newLines);
        out.output(document, writer);
    }

    public static String getXmlErrorsAsString(List errors) {
        return "Xml errors: [" + ListUtil.collect(errors, new Transformer(){

            public Object transform(Object obj) {
                SAXParseException saxParseException = (SAXParseException)obj;
                return saxParseException.getLocalizedMessage() + ";";
            }
        }) + "]";
    }

    public static String escapeElementEntities(String entityText) {
        int i;
        if (entityText == null) {
            return entityText;
        }
        StringBuffer buff = new StringBuffer();
        char[] block = entityText.toCharArray();
        String stEntity = null;
        int last = 0;
        for (i = 0; i < block.length; ++i) {
            switch (block[i]) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                }
            }
            if (stEntity == null) continue;
            buff.append(block, last, i - last);
            buff.append(stEntity);
            stEntity = null;
            last = i + 1;
        }
        if (last < block.length) {
            buff.append(block, last, i - last);
        }
        return buff.toString();
    }

    public static String standardize(String string) throws IOException {
        StringBuffer standardizedStringBuffer = new StringBuffer("");
        StringReader isr = new StringReader(string);
        int character = isr.read();
        while (character != -1) {
            Integer characterInt = new Integer(character);
            if (mappings.containsKey(characterInt)) {
                standardizedStringBuffer.append(mappings.get(characterInt));
            } else {
                standardizedStringBuffer.append((char)character);
            }
            character = isr.read();
        }
        return standardizedStringBuffer.toString();
    }

    private static Map<Integer, String> fillMappings() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(new Integer(8364), "Euro");
        result.put(new Integer(8218), "'");
        result.put(new Integer(402), " ");
        result.put(new Integer(8222), "\"");
        result.put(new Integer(8230), "...");
        result.put(new Integer(8224), " ");
        result.put(new Integer(8225), " ");
        result.put(new Integer(710), "^");
        result.put(new Integer(8240), "%o");
        result.put(new Integer(352), " ");
        result.put(new Integer(8249), "&lt;");
        result.put(new Integer(338), " ");
        result.put(new Integer(381), " ");
        result.put(new Integer(8216), "'");
        result.put(new Integer(8217), "'");
        result.put(new Integer(8220), "\"");
        result.put(new Integer(8221), "\"");
        result.put(new Integer(8226), "-");
        result.put(new Integer(8211), "-");
        result.put(new Integer(8212), "-");
        result.put(new Integer(732), "~");
        result.put(new Integer(8482), "TM");
        result.put(new Integer(353), " ");
        result.put(new Integer(8250), "&gt;");
        result.put(new Integer(339), " ");
        result.put(new Integer(382), " ");
        result.put(new Integer(376), " ");
        result.put(new Integer(161), "!");
        result.put(new Integer(162), " ");
        result.put(new Integer(163), "Pound");
        result.put(new Integer(164), " ");
        result.put(new Integer(165), " ");
        result.put(new Integer(166), "|");
        result.put(new Integer(167), " ");
        result.put(new Integer(168), " ");
        result.put(new Integer(169), "Copyright");
        result.put(new Integer(171), "&lt;&lt;");
        result.put(new Integer(172), " ");
        result.put(new Integer(173), " ");
        result.put(new Integer(174), " ");
        result.put(new Integer(175), "-");
        result.put(new Integer(176), "o");
        result.put(new Integer(177), "+/-");
        result.put(new Integer(178), "2");
        result.put(new Integer(179), "3");
        result.put(new Integer(180), "'");
        result.put(new Integer(181), " ");
        result.put(new Integer(182), " ");
        result.put(new Integer(183), "-");
        result.put(new Integer(184), ",");
        result.put(new Integer(185), "1");
        result.put(new Integer(187), "&gt;&gt;");
        result.put(new Integer(188), "1/4");
        result.put(new Integer(189), "1/2");
        result.put(new Integer(190), "3/4");
        result.put(new Integer(191), "?");
        result.put(new Integer(196), "A");
        result.put(new Integer(197), "A");
        result.put(new Integer(198), "AE");
        result.put(new Integer(203), "E");
        result.put(new Integer(207), "I");
        result.put(new Integer(208), "D");
        result.put(new Integer(214), "O");
        result.put(new Integer(215), "x");
        result.put(new Integer(216), "0");
        result.put(new Integer(220), "U");
        result.put(new Integer(221), "'Y");
        result.put(new Integer(222), " ");
        result.put(new Integer(223), "B");
        result.put(new Integer(228), "a");
        result.put(new Integer(229), "a");
        result.put(new Integer(230), "ae");
        result.put(new Integer(235), "e");
        result.put(new Integer(239), "i");
        result.put(new Integer(240), " ");
        result.put(new Integer(246), "o");
        result.put(new Integer(247), "/");
        result.put(new Integer(248), "0");
        result.put(new Integer(252), "u");
        result.put(new Integer(253), "'y");
        result.put(new Integer(254), " ");
        result.put(new Integer(255), "y");
        return result;
    }

    private static class FeatureValidatingSAXBuilder
    extends SAXBuilder {
        public FeatureValidatingSAXBuilder() {
        }

        public FeatureValidatingSAXBuilder(String s) {
            super(s);
        }

        public FeatureValidatingSAXBuilder(String s, boolean b) {
            super(s, b);
        }

        public FeatureValidatingSAXBuilder(boolean b) {
            super(b);
        }

        @Override
        public void setFeature(String key, boolean value) {
            super.setFeature(key, value);
            try {
                XMLReader dummyReader = super.createParser();
                SAXHandler dummyHandler = super.createContentHandler();
                this.configureParser(dummyReader, dummyHandler);
            }
            catch (Exception e) {
                Logger.getDefault().info((Object)("While setting parser feature \"" + key + "\" got exception: " + e.getMessage() + ". Removing it from feature list"));
                this.removeFeature(key);
            }
        }

        private void removeFeature(String key) {
            try {
                Field featuresField = SAXBuilder.class.getDeclaredField("features");
                featuresField.setAccessible(true);
                Map features = (Map)featuresField.get(this);
                features.remove(key);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

