/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import pt.opensoft.field.ValidationException;
import pt.opensoft.util.SystemParameters;
import pt.opensoft.util.WrappedRuntimeException;
import pt.opensoft.xml.XmlElement;
import pt.opensoft.xml.XmlProcessor;
import pt.opensoft.xml.XmlUtil;

public class XmlReader
implements ContentHandler {
    public static final String DEFAULT_ENCODING = SystemParameters.DEFAULT_ENCODING;
    private static final int DEFAULT_AVG_XPATH_ELEMENT_SIZE = 12;
    protected XmlProcessor processor;
    protected XMLReader parser;
    protected Locator locator;
    protected Stack elements;
    protected StringBuffer text;
    private final List<String> namespaces;
    private String schema;
    private boolean isNamespaceAware;
    private boolean addXPathToXmlElement = false;

    public XmlReader(XmlProcessor processor) {
        this(processor, XmlUtil.getXercesSAXParser());
    }

    public XmlReader(XmlProcessor processor, XMLReader reader) {
        this.processor = processor;
        this.parser = reader;
        this.setContentHandler(this);
        this.namespaces = new ArrayList<String>();
        this.isNamespaceAware = false;
    }

    public void parse(File file) throws SAXException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.parse(in);
        }
    }

    public void parse(InputStream in) throws SAXException, IOException {
        try (InputStreamReader reader = new InputStreamReader(in, DEFAULT_ENCODING);){
            this.parse(reader);
        }
    }

    public void parse(Reader reader) throws SAXException, IOException {
        InputSource in = new InputSource(reader);
        this.parser.parse(in);
    }

    protected void setContentHandler(ContentHandler handler) {
        this.parser.setContentHandler(handler);
    }

    protected void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    protected void setErrorHandler(ErrorHandler handler) {
        this.parser.setErrorHandler(handler);
    }

    public void setFeature(String feature, boolean value) {
        try {
            this.parser.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException e) {
            throw new WrappedRuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void setProperty(String name, String value) {
        try {
            this.parser.setProperty(name, value);
        }
        catch (SAXNotRecognizedException e) {
            throw new WrappedRuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void setSchema(String schemas) {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setFeature("http://apache.org/xml/features/validation/schema", true);
        this.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        this.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemas);
        this.schema = schemas.split(" ")[0];
    }

    public void setAddXPathToXmlElement(boolean addXPathToXmlElement) {
        this.addXPathToXmlElement = addXPathToXmlElement;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.elements = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
        this.locator = null;
        this.elements = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String namespace) throws SAXException {
        this.namespaces.add(namespace);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this.isNamespaceAware = isNamespaceAware;
    }

    @Override
    public void startElement(String namespace, String name, String qName, Attributes attributes) throws SAXException {
        if (this.isNamespaceAware && !this.namespaces.contains(this.schema)) {
            this.isNamespaceAware = false;
            throw new ValidationException("XML", "Cannot find the declaration of element '" + name + "'.", this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        XmlElement element = new XmlElement(name, this.locator.getLineNumber(), this.locator.getColumnNumber());
        for (int i = 0; i < attributes.getLength(); ++i) {
            element.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
        }
        if (this.elements.size() > 0) {
            ((XmlElement)this.elements.peek()).setHasChildren(true);
        }
        element.setIndentLevel(this.elements.size());
        this.elements.push(element);
        if (this.addXPathToXmlElement) {
            element.setXPath(this.getXPathString());
        }
        this.text = null;
        try {
            this.processor.startElement(element, element.getLine(), element.getColumn());
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage();
            throw new ValidationException("XML", message, element.getLine(), element.getColumn(), e);
        }
    }

    @Override
    public void endElement(String namespace, String name, String qName) throws SAXException {
        XmlElement element = (XmlElement)this.elements.pop();
        if (!element.getName().equals(name)) {
            throw new IllegalArgumentException(name + " != " + element.getName());
        }
        if (this.text != null) {
            element.setText(this.text.toString());
            this.text = null;
        }
        try {
            this.processor.endElement(element, element.getLine(), element.getColumn());
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage();
            throw new ValidationException("XML", message, element.getLine(), element.getColumn(), e);
        }
    }

    @Override
    public void characters(char[] chars, int off, int len) throws SAXException {
        if (this.text == null) {
            this.text = new StringBuffer(len);
        }
        this.text.append(chars, off, len);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int off, int len) throws SAXException {
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
        throw new SAXException("Processing Instructions not allowed");
    }

    @Override
    public void skippedEntity(String entity) throws SAXException {
    }

    private String getXPathString() {
        StringBuilder xpath = new StringBuilder(this.elements.size() * 12);
        for (Object object : this.elements) {
            XmlElement element = (XmlElement)object;
            if (xpath.length() > 0) {
                xpath.append("/");
            }
            xpath.append(element.getName());
        }
        return xpath.toString();
    }
}

