/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pt.opensoft.util.DateTime;
import pt.opensoft.util.InvalidDate;
import pt.opensoft.util.StringUtil;

public class Timestamp
extends DateTime {
    public static final String NANOS_FORMAT = "SSSSSS";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd-HH.mm.ss.SSSSSS";
    public static final Timestamp NULL_TIMESTAMP = new Timestamp("0001-01-01-00.00.00.000000", "yyyy-MM-dd-HH.mm.ss.SSSSSS", false);
    private static final char NANO_PATTERN = 'S';
    private static final String NORMALIZATION_REGEX = "([ .,:;_\\-/\\\\]*)(S+)";
    private DateTime datetime;
    private String nanosSeparator = ".";
    private String nanosFormat = "SSSSSS";
    private long nanos;

    public Timestamp() {
        this(TIMESTAMP_FORMAT, false);
    }

    public Timestamp(String format) {
        this(format, false);
    }

    public Timestamp(String format, boolean lenient) {
        this(new Date(), format, lenient);
    }

    public Timestamp(String date, String format, boolean lenient) {
        super(date, format, lenient);
        this.datetime = new DateTime(date, Timestamp.normalizeDateTimeFormat(format), lenient);
        this.setTimestampFormat(format);
        this.setNanos(this.parseNanos(date, format));
    }

    public Timestamp(Date date) {
        this(date, TIMESTAMP_FORMAT, false);
    }

    public Timestamp(Date date, String format) {
        this(date, format, false);
    }

    public Timestamp(Date date, String format, boolean lenient) {
        super(date, format, lenient);
        this.datetime = new DateTime(date, Timestamp.normalizeDateTimeFormat(format), lenient);
        this.setTimestampFormat(format);
        this.setNanos(date);
    }

    public Timestamp(java.sql.Timestamp date) {
        this(date, TIMESTAMP_FORMAT, false);
    }

    public Timestamp(java.sql.Timestamp date, String format) {
        this(date, format, false);
    }

    public Timestamp(java.sql.Timestamp date, String format, boolean lenient) {
        super((Date)Timestamp.buildDateTimeWithFunnyMillis(date, format, lenient), format, lenient);
        this.datetime = new DateTime(date, Timestamp.normalizeDateTimeFormat(format), lenient);
        this.setTimestampFormat(format);
        this.setNanos(date);
    }

    @Override
    public final void setDateTime(int year, int month, int day, int hour, int minute, int second, int millis) {
        super.setDateTime(year, month, day, hour, minute, second, millis);
        this.datetime.setDateTime(year, month, day, hour, minute, second, millis);
    }

    @Override
    public final void setTime(int hour, int minute, int second, int millis) {
        super.setTime(hour, minute, second, millis);
        this.datetime.setTime(hour, minute, second, millis);
    }

    @Override
    public final DateTime add(int field, int ammount) {
        super.add(field, ammount);
        this.datetime.add(field, ammount);
        return this;
    }

    @Override
    public final DateTime addYears(int years) {
        super.addYears(years);
        this.datetime.addYears(years);
        return this;
    }

    @Override
    public final DateTime addMonths(int months) {
        super.addMonths(months);
        this.datetime.addMonths(months);
        return this;
    }

    @Override
    public final DateTime addDays(int days) {
        super.addDays(days);
        this.datetime.addDays(days);
        return this;
    }

    @Override
    public final DateTime addHours(int hours) {
        super.addHours(hours);
        this.datetime.addHours(hours);
        return this;
    }

    @Override
    public final DateTime addMinutes(int minutes) {
        super.addMinutes(minutes);
        this.datetime.addMinutes(minutes);
        return this;
    }

    @Override
    public final DateTime addSeconds(int seconds) {
        super.addSeconds(seconds);
        this.datetime.addSeconds(seconds);
        return this;
    }

    @Override
    public final DateTime addMillis(int millis) {
        super.addMillis(millis);
        this.datetime.addMillis(millis);
        return this;
    }

    @Override
    public final DateTime addYearWeeks(int weeks) {
        super.addYearWeeks(weeks);
        this.datetime.addYearWeeks(weeks);
        return this;
    }

    private static DateTime buildDateTimeWithFunnyMillis(java.sql.Timestamp timestamp, String format, boolean lenient) {
        DateTime dt = new DateTime();
        dt.setFormat(format);
        dt.setLenient(lenient);
        dt.setDateTime(timestamp.getTime());
        int nanos = timestamp.getNanos();
        if (nanos >= 1000 && nanos < 1000000) {
            dt.setMillis(nanos / 1000);
        }
        return dt;
    }

    protected long parseNanos(String date, String format) {
        Matcher m = Pattern.compile("S+").matcher(format);
        if (m.find()) {
            String subString = date.substring(m.start());
            long nanoPart = Long.parseLong(subString);
            if (this.nanosFormat.length() == 9) {
                return nanoPart;
            }
            long norm = (long)Math.pow(10.0, 9 - subString.length());
            return nanoPart * norm;
        }
        return 0L;
    }

    private static String normalizeDateTimeFormat(String format) {
        return format.replaceAll(NORMALIZATION_REGEX, "");
    }

    private void setTimestampFormat(String format) {
        Matcher m = Pattern.compile(NORMALIZATION_REGEX).matcher(format);
        if (m.find()) {
            this.nanosSeparator = m.group(1);
            this.nanosFormat = m.group(0).substring(this.nanosSeparator.length());
        } else {
            this.nanosSeparator = "";
            this.nanosFormat = "";
        }
        if (this.nanosFormat.length() > 9) {
            throw new InvalidDate("Formato de timestamp inv\u00e1lido '" + format + "'.");
        }
    }

    private void setNanos(java.sql.Timestamp date) {
        DateTime datetime = new DateTime(date);
        this.datetime.addMillis(-datetime.get(14));
        this.setNanos(date.getNanos());
    }

    private void setNanos(Date date) {
        this.setNanos(new DateTime(date));
    }

    private void setNanos(DateTime date) {
        this.datetime.addMillis(-date.get(14));
        this.setNanos((long)date.get(14) * 1000000L);
    }

    private void setNanos(long nanos) {
        this.nanos = nanos;
    }

    private String getFormatedNanos(String nanosFormat) {
        if (nanosFormat.length() == 0) {
            return "";
        }
        int significantNanos = nanosFormat.length();
        return StringUtil.padZeros(this.nanos, 9).substring(0, significantNanos);
    }

    private String getFormatedNanos() {
        return this.getFormatedNanos(this.nanosFormat);
    }

    public synchronized String formatTimestamp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.datetime.format()).append(this.nanosSeparator).append(this.getFormatedNanos());
        return buffer.toString();
    }

    @Override
    public String format() {
        return this.formatTimestamp();
    }

    public static void main(String[] args) {
        DateTime date = new DateTime("2005-07-22 19:33:00");
        java.sql.Timestamp sqltimestamp = new java.sql.Timestamp(date.getTime());
        sqltimestamp.setNanos(443146);
        System.out.println("sqltimestamp = " + sqltimestamp);
        Timestamp timestamp = new Timestamp(sqltimestamp, TIMESTAMP_FORMAT);
        System.out.println("timestamp.format() = " + timestamp.formatTimestamp());
    }

    @Override
    public Object clone() {
        Timestamp other = (Timestamp)super.clone();
        if (this.datetime != null) {
            other.datetime = (DateTime)this.datetime.clone();
        }
        return other;
    }
}

