/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class NameValue
implements Cloneable,
Serializable {
    private Hashtable _nameValue;
    private String _dataSeparator = "&";
    private String _fieldSeparator = "=";

    public NameValue() {
        this._nameValue = new Hashtable();
    }

    public NameValue(String data, String dataSeparator, String fieldSeparator) {
        this._dataSeparator = dataSeparator;
        this._fieldSeparator = fieldSeparator;
        this.parseString(data);
    }

    public NameValue(String data) {
        this.parseString(data);
    }

    public NameValue(String data, String tags, String dataSeparator, String fieldSeparator) {
        this._dataSeparator = dataSeparator;
        this._fieldSeparator = fieldSeparator;
        this.parseStringWithTags(data, tags);
    }

    public NameValue(String data, String tags) {
        this.parseStringWithTags(data, tags);
    }

    public void parseString(String data) {
        this._nameValue = new Hashtable();
        StringTokenizer st = new StringTokenizer(data, this._dataSeparator);
        int index = 0;
        String name = "";
        String value = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            index = token.indexOf(this._fieldSeparator);
            if (index == -1) continue;
            name = token.substring(0, index);
            value = token.substring(index + 1);
            if (name.equals("") || value.equals("")) continue;
            this.addNameValue(name, value);
        }
    }

    public void parseStringWithComplexSeparator(String data) {
        String dataSeparator = "&Anexo";
        String prefix = "Anexo";
        List<String> listAnexos = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "G1", "H", "I", "J", "L");
        String[] stringTokenizer = data.split("&Anexo");
        int index = 0;
        String name = "";
        String value = "";
        for (int i = 0; i < stringTokenizer.length; ++i) {
            String token = stringTokenizer[i];
            index = token.indexOf(this._fieldSeparator);
            if (index == -1) {
                throw new RuntimeException("N\u00e3o foi poss\u00edvel identificar o Anexo na decalra\u00e7\u00e3o em flat file.");
            }
            name = token.substring(0, index);
            value = token.substring(index + 1);
            if (name.equals("") || value.equals("")) {
                throw new RuntimeException("N\u00e3o foi poss\u00edvel identificar o conte\u00fado do Anexo na decalra\u00e7\u00e3o em flat file.");
            }
            if (name.equals("Rosto")) {
                this.addNameValue(name, value);
                continue;
            }
            if (listAnexos.contains(name)) {
                this.addNameValue("Anexo" + name, value);
                continue;
            }
            throw new RuntimeException("O Anexo identificado n\u00e3o \u00e9 v\u00e1lido na declara\u00e7\u00e3o.");
        }
    }

    public void parseStringWithTags(String data, String tags) {
        String[] result;
        this._nameValue = new Hashtable();
        String regex = this._dataSeparator;
        if (!StringUtils.isEmpty((String)tags)) {
            regex = regex + "(?=" + tags + ")";
        }
        data = StringUtils.removeEnd((String)data, (String)this._dataSeparator);
        for (String aResult : result = data.split(regex)) {
            String[] nameValue = aResult.split(this._fieldSeparator, 2);
            this.addNameValue(nameValue[0], nameValue[1]);
        }
    }

    public void setDataSeparator(String dataSeparator) {
        this._dataSeparator = dataSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this._fieldSeparator = fieldSeparator;
    }

    public void addNameValue(Object name, Object value) {
        if (this._nameValue.containsKey(name)) {
            Vector v = (Vector)this._nameValue.get(name);
            v.addElement(value);
            this._nameValue.put(name, v);
        } else {
            Vector<Object> v = new Vector<Object>();
            v.addElement(value);
            this._nameValue.put(name, v);
        }
    }

    public void setNameValue(Object name, Object value) {
        this.remove(name);
        this.addNameValue(name, value);
    }

    public Object getValue(Object name) {
        Vector v = (Vector)this._nameValue.get(name);
        if (v != null) {
            return v.firstElement();
        }
        return null;
    }

    public String getString(Object name) {
        return (String)this.getValue(name);
    }

    public int getInt(Object name) {
        return Integer.parseInt(this.getString(name));
    }

    public long getLong(Object name) {
        return Long.parseLong(this.getString(name));
    }

    public Object getValue(Object name, int i) {
        Vector v = (Vector)this._nameValue.get(name);
        if (v != null) {
            return v.elementAt(i);
        }
        return null;
    }

    public int getValueCount(Object name) {
        Vector v = (Vector)this._nameValue.get(name);
        if (v != null) {
            return v.size();
        }
        return 0;
    }

    public Object[] getValues(Object name) {
        Vector v = (Vector)this._nameValue.get(name);
        if (v != null) {
            int size = v.size();
            Object[] ob = new Object[size];
            v.copyInto(ob);
            return ob;
        }
        return null;
    }

    public Vector getValuesVector(Object name) {
        return (Vector)this._nameValue.get(name);
    }

    public String getValuesAsString(Object name) {
        Object[] cols = this.getValues(name);
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < cols.length; ++i) {
            if (i != 0) {
                str.append("+");
            }
            str.append((String)cols[i]);
        }
        return str.toString();
    }

    public String toString() {
        return this._nameValue.toString();
    }

    public boolean isEmpty() {
        return this._nameValue.isEmpty();
    }

    public void pack() {
        String[] elements = this.elements();
        for (int i = 0; i < elements.length; ++i) {
            Vector v = (Vector)this._nameValue.get(elements[i]);
            v.trimToSize();
        }
    }

    public String[] elements() {
        String[] elements = new String[this._nameValue.size()];
        int i = 0;
        Enumeration e = this._nameValue.keys();
        while (e.hasMoreElements()) {
            elements[i] = (String)e.nextElement();
            ++i;
        }
        return elements;
    }

    public String toMessage() {
        StringBuffer message = new StringBuffer("");
        Enumeration e = this._nameValue.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object[] ob = this.getValues(key);
            for (int i = 0; i < ob.length; ++i) {
                message.append(key);
                message.append(this._fieldSeparator);
                message.append(ob[i]);
                message.append(this._dataSeparator);
            }
        }
        return message.toString();
    }

    public void remove(Object name) {
        this._nameValue.remove(name);
    }

    public void clear() {
        this._nameValue.clear();
    }

    public boolean contains(String name) {
        return this._nameValue.containsKey(name);
    }

    public Object clone() throws CloneNotSupportedException {
        NameValue clone = (NameValue)super.clone();
        if (this._nameValue != null) {
            clone._nameValue = (Hashtable)this._nameValue.clone();
        }
        Enumeration e = this._nameValue.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            clone._nameValue.put(key, this.getValuesVector(key).clone());
        }
        return clone;
    }

    public static void main(String[] args) throws Exception {
        NameValue nv = new NameValue();
        nv.addNameValue("arg1", "blabla");
        nv.addNameValue("arg2", "bleble");
        nv.addNameValue("arg2", "blibli");
        System.out.println("1->" + nv.toString());
        NameValue clone = (NameValue)nv.clone();
        System.out.println("2->" + clone.toString());
        clone.addNameValue("arg2", "bloblo");
        System.out.println("1->" + nv.toString());
        System.out.println("2->" + clone.toString());
    }
}

