/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.util;

import java.util.Hashtable;
import java.util.List;
import pt.opensoft.util.ListUtil;
import pt.opensoft.util.StringUtil;

public class Name {
    protected static final Hashtable femininos = Name.loadFemininos();
    public static final char DESCONHECIDO = 'D';
    public static final char FEMININO = 'F';
    public static final char MASCULINO = 'M';
    private static final int ARTICLE_MAX_SIZE = 3;

    protected static Hashtable loadFemininos() {
        Hashtable<String, String> fem = new Hashtable<String, String>();
        fem.put("adelaide", "adelaide");
        fem.put("alice", "alice");
        fem.put("assuncao", "assuncao");
        fem.put("beatriz", "beatriz");
        fem.put("carmen", "carmen");
        fem.put("conceicao", "conceicao");
        fem.put("dulce", "dulce");
        fem.put("elizabete", "elizabete");
        fem.put("eunice", "eunice");
        fem.put("florisel", "florisel");
        fem.put("gertrudes", "gertrudes");
        fem.put("gestrudes", "gestrudes");
        fem.put("graciete", "graciete");
        fem.put("ines", "ines");
        fem.put("irene", "irene");
        fem.put("isabel", "isabel");
        fem.put("ivone", "ivone");
        fem.put("leonor", "leonor");
        fem.put("lurdes", "lurdes");
        fem.put("lourdes", "lourdes");
        fem.put("matilde", "matilde");
        fem.put("raquel", "raquel");
        fem.put("rosario", "rosario");
        fem.put("rute", "rute");
        fem.put("salete", "salete");
        fem.put("salome", "salome");
        fem.put("sarah", "sarah");
        fem.put("simone", "simone");
        fem.put("susan", "susan");
        fem.put("violante", "violante");
        fem.put("valdete", "valdete");
        return fem;
    }

    public static boolean isDesconhecido(String nome) {
        return Name.sexo(nome) == 'D';
    }

    public static boolean isFeminino(String nome) {
        return Name.sexo(nome) == 'F';
    }

    public static boolean isMasculino(String nome) {
        return Name.sexo(nome) == 'M';
    }

    public static char sexo(String nome) {
        if (nome == null) {
            return 'D';
        }
        if (nome.length() == 0) {
            return 'D';
        }
        int pos = nome.indexOf(32);
        String first = pos == -1 ? nome.toLowerCase() : nome.substring(0, pos).toLowerCase();
        if (femininos.containsKey(first = StringUtil.normalize(first))) {
            return 'F';
        }
        char last = first.charAt(first.length() - 1);
        if (last == 'a') {
            return 'F';
        }
        return 'M';
    }

    public static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toUpperCase(str.charAt(0)));
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            char last = str.charAt(i - 1);
            if (last == ' ') {
                buffer.append(Character.toUpperCase(ch));
                continue;
            }
            if (last == '.') {
                buffer.append(Character.toUpperCase(ch));
                continue;
            }
            if (last == '-') {
                buffer.append(Character.toUpperCase(ch));
                continue;
            }
            if (last == '\'') {
                buffer.append(Character.toUpperCase(ch));
                continue;
            }
            buffer.append(Character.toLowerCase(ch));
        }
        return buffer.toString();
    }

    public static String normalize(String nome) {
        nome = StringUtil.trim(nome);
        nome = Name.capitalize(nome);
        nome = StringUtil.replace(nome, " A ", " a ");
        nome = StringUtil.replace(nome, " As ", " as ");
        nome = StringUtil.replace(nome, " O ", " o ");
        nome = StringUtil.replace(nome, " Os ", " os ");
        nome = StringUtil.replace(nome, " E ", " e ");
        nome = StringUtil.replace(nome, " Y ", " y ");
        nome = StringUtil.replace(nome, " De ", " de ");
        nome = StringUtil.replace(nome, " Do ", " do ");
        nome = StringUtil.replace(nome, " Dos ", " dos ");
        nome = StringUtil.replace(nome, " Da ", " da ");
        nome = StringUtil.replace(nome, " Das ", " das ");
        nome = StringUtil.replace(nome, " Ii ", " II ");
        nome = StringUtil.replace(nome, " Iii ", " III ");
        nome = StringUtil.replace(nome, " Iv ", " IV ");
        nome = StringUtil.replace(nome, " Vi ", " VI ");
        nome = StringUtil.replace(nome, " Vii ", " VII ");
        nome = StringUtil.replace(nome, " Viii ", " VIII ");
        nome = StringUtil.replace(nome, " Ix ", " IX ");
        nome = StringUtil.replace(nome, " Xi ", " XI ");
        nome = StringUtil.replace(nome, " Xii ", " XII ");
        nome = StringUtil.replace(nome, " Xiii ", " XIII ");
        nome = StringUtil.replace(nome, " Xiv ", " XIV ");
        nome = StringUtil.replace(nome, " Xvi ", " XVI ");
        nome = StringUtil.replace(nome, " Xvii ", " XVII ");
        nome = StringUtil.replace(nome, " Xviii ", " XVIII ");
        nome = StringUtil.replace(nome, " Ixx ", " IXX ");
        nome = StringUtil.replace(nome, " Xxi ", " XXI ");
        nome = StringUtil.replace(nome, " Xxii ", " XXII ");
        nome = StringUtil.replace(nome, " Xxiii ", " XXIII ");
        return nome;
    }

    public static String first(String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().equals("")) {
            return "";
        }
        int index = name.indexOf(" ");
        if (index == -1) {
            return name.trim();
        }
        String first = name.substring(0, index);
        return first.trim();
    }

    public static String family(String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().equals("")) {
            return "";
        }
        int index = name.lastIndexOf(" ");
        if (index == -1) {
            return "";
        }
        String family = name.substring(index + 1);
        if ((index = name.lastIndexOf(" ", index - 1)) == -1) {
            return family.trim();
        }
        family = name.substring(index + 1);
        return family.trim();
    }

    public static String last(String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().equals("")) {
            return "";
        }
        int index = name.lastIndexOf(" ");
        if (index == -1) {
            return "";
        }
        String last = name.substring(index + 1);
        return last.trim();
    }

    public static String compress(String name, int maxLength) {
        int i;
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength should be <= 0, was: " + maxLength);
        }
        if (name.length() <= maxLength) {
            return name;
        }
        String separator = " ";
        if (name.indexOf(separator) == -1) {
            return name.substring(0, maxLength);
        }
        List subnames = ListUtil.toList(name, separator);
        int size = subnames.size();
        for (i = 1; i < size - 1 && StringUtil.length(subnames, separator) > maxLength; ++i) {
            String subname = (String)subnames.get(i);
            if (subname.length() <= 3) continue;
            subnames.set(i, subname.substring(0, 1));
        }
        if (StringUtil.length(subnames, separator) <= maxLength) {
            return ListUtil.toString(subnames, separator);
        }
        size = subnames.size();
        for (i = 0; i < size - 1 && StringUtil.length(subnames, separator) > maxLength; ++i) {
            subnames.remove(1);
            size = subnames.size();
        }
        if (StringUtil.length(subnames, separator) <= maxLength) {
            return ListUtil.toString(subnames, separator);
        }
        String firstName = (String)subnames.get(0);
        subnames.set(0, firstName.substring(0, 1));
        if (StringUtil.length(subnames, separator) <= maxLength) {
            return ListUtil.toString(subnames, separator);
        }
        subnames.remove(0);
        String lastName = (String)subnames.get(0);
        if (lastName.length() <= maxLength) {
            return lastName;
        }
        return lastName.substring(0, Math.min(maxLength, lastName.length()));
    }

    public static void main(String[] args) throws Exception {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                buffer.append(' ');
            }
            buffer.append(args[i]);
        }
        String nome = Name.normalize(buffer.toString());
        System.out.println("Name       : " + nome);
        System.out.println("Primeiro   : " + Name.first(nome));
        System.out.println("Ultimo     : " + Name.last(nome));
        System.out.println("Apelido    : " + Name.family(nome));
    }
}

