/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import pt.opensoft.io.ZipEntry;
import pt.opensoft.io.ZipOutputStream;
import pt.opensoft.util.SystemParameters;

public class ZipWriter
extends PrintWriter {
    public static final String DEFAULT_ENCODING = SystemParameters.DEFAULT_ENCODING;
    private final ZipOutputStream zos;

    public ZipWriter(String name) throws IOException {
        this(new ZipOutputStream(name), DEFAULT_ENCODING);
    }

    public ZipWriter(String name, String encoding) throws IOException {
        this(new ZipOutputStream(name), encoding);
    }

    public ZipWriter(File file) throws IOException {
        this(new ZipOutputStream(file), DEFAULT_ENCODING);
    }

    public ZipWriter(File file, String encoding) throws IOException {
        this(new ZipOutputStream(file), encoding);
    }

    public ZipWriter(OutputStream out) throws IOException {
        this(new ZipOutputStream(out), DEFAULT_ENCODING);
    }

    public ZipWriter(OutputStream out, String encoding) throws IOException {
        this(new ZipOutputStream(out), encoding);
    }

    private ZipWriter(ZipOutputStream out, String encoding) throws IOException {
        super(new OutputStreamWriter((OutputStream)out, encoding));
        this.zos = out;
    }

    public ZipEntry newEntry(String name) throws IOException {
        return this.zos.newEntry(name, true);
    }

    public ZipEntry newEntry(String name, boolean deflated) throws IOException {
        return this.zos.newEntry(name, deflated);
    }

    public void closeEntry() throws IOException {
        this.flush();
        this.zos.closeEntry();
    }
}

