/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.io;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import pt.opensoft.logger.Logger;
import pt.opensoft.util.ClassUtil;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected long _delay = 60000L;
    protected File _file;
    protected Comparator _comparator = null;
    long _lastModif = 0L;
    boolean _warnedAlready = false;
    boolean _stopped = false;
    public static Comparator COMPARADOR_LAST_MODIFIED_TIME = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof File) && !(o2 instanceof File)) {
                throw new IllegalArgumentException("Object is not of type File!");
            }
            return ((File)o1).lastModified() <= ((File)o2).lastModified() ? -1 : 1;
        }
    };
    public static Comparator COMPARADOR_NOME_FICHEIRO = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof File) && !(o2 instanceof File)) {
                throw new IllegalArgumentException("Object is not of type File!");
            }
            return ((File)o1).compareTo((File)o2);
        }
    };

    protected FileWatchdog(File file) {
        this(file, false);
    }

    protected FileWatchdog(File file, Comparator comparator) {
        this(file);
        this._comparator = comparator;
    }

    protected FileWatchdog(File file, boolean checkAndConfigureRightNow) {
        this._file = file;
        this.setDaemon(true);
        if (checkAndConfigureRightNow) {
            this.checkAndConfigure();
        }
    }

    protected FileWatchdog(File file, Comparator comparator, boolean checkAndConfigureRightNow) {
        this(file, checkAndConfigureRightNow);
        this._comparator = comparator;
    }

    public void setDelay(long delay) {
        this._delay = delay;
    }

    protected abstract void doOnChange(File var1);

    protected void checkAndConfigure() {
        if (this._file.exists()) {
            if (!this._file.isDirectory()) {
                this._lastModif = this.check(this._file);
            } else {
                File[] files = this._file.listFiles();
                if (this._comparator != null) {
                    Arrays.sort(files, this._comparator);
                }
                long maxLastModif = this._lastModif;
                for (int i = 0; i < files.length; ++i) {
                    long thisLastModif;
                    File file = files[i];
                    if (!file.isFile() || (thisLastModif = this.check(file)) <= maxLastModif) continue;
                    maxLastModif = thisLastModif;
                }
                this._lastModif = maxLastModif;
            }
        } else if (!this._warnedAlready) {
            Logger.getDefault().debug((Object)("[" + this._file.getPath() + "] does not exist."));
            this._warnedAlready = true;
        }
    }

    private long check(File file) {
        long l = file.lastModified();
        if (l > this._lastModif) {
            this.doOnChange(file);
            this._warnedAlready = false;
        }
        return l;
    }

    @Override
    public void run() {
        while (!this._stopped) {
            try {
                Thread.sleep(this._delay);
            }
            catch (InterruptedException e) {
                Logger.getDefault().error((Object)(ClassUtil.getClassName(this.getClass()) + " throwing InterruptedException"), (Throwable)e);
            }
            this.checkAndConfigure();
        }
    }

    @Override
    public void interrupt() {
        this._stopped = true;
        super.interrupt();
    }
}

