/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.http;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import pt.opensoft.msg.Session;
import pt.opensoft.util.ListUtil;

public class HttpSession
extends Session {
    public static final String SESSION_ACTIVATION_LISTENER = "sessionactivationlistener";
    protected javax.servlet.http.HttpSession session;

    public HttpSession(javax.servlet.http.HttpSession session) {
        this.session = session;
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public List getNames() {
        return ListUtil.toList(this.session.getAttributeNames());
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public boolean isValid() {
        try {
            this.getValue(" ");
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public Object getValue(String name) {
        return this.session.getAttribute(name);
    }

    public List getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        Enumeration names = this.session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.getValue(name);
            values.add(value);
        }
        return values;
    }

    public Object remove(String s) {
        Object value = this.getValue(s);
        this.session.removeAttribute(s);
        return value;
    }

    public void clear() {
        Enumeration _attributes = this.session.getAttributeNames();
        while (_attributes.hasMoreElements()) {
            String _attributeName = (String)_attributes.nextElement();
            if (_attributeName.equals(SESSION_ACTIVATION_LISTENER)) continue;
            this.session.removeAttribute(_attributeName);
        }
    }

    public void setMaxInactiveInterval(int i) {
        this.session.setMaxInactiveInterval(i);
    }

    public Object setValue(String name, Object value) {
        this.session.setAttribute(name, value);
        return value;
    }
}

