/*
 * Decompiled with CFR 0.152.
 */
package pt.opensoft.field;

import pt.opensoft.field.NumericField;
import pt.opensoft.util.CharUtil;
import pt.opensoft.util.StringUtil;

public class TelefoneField
extends NumericField {
    protected static char[] VALID_CODES = new char[]{'2', '9', '3'};
    protected static char[] SMS_CODES = new char[]{'2', '9', '3'};

    public static boolean validate(int telefone) {
        return TelefoneField.validate(String.valueOf(telefone));
    }

    public static boolean validate(String telefone) {
        if (!TelefoneField.validateSyntax(telefone)) {
            return false;
        }
        return CharUtil.in(telefone.charAt(0), VALID_CODES);
    }

    public static boolean validateSyntax(String telefone) {
        if (telefone == null) {
            return false;
        }
        if (telefone.length() != 9) {
            return false;
        }
        return StringUtil.isNumeric(telefone);
    }

    public static boolean smsCapable(int telefone) {
        return TelefoneField.smsCapable(String.valueOf(telefone));
    }

    public static boolean smsCapable(long telefone) {
        return TelefoneField.smsCapable(String.valueOf(telefone));
    }

    public static boolean smsCapable(String telefone) {
        if (telefone == null) {
            return false;
        }
        return CharUtil.in(telefone.charAt(0), SMS_CODES);
    }

    public TelefoneField(String name) {
        super(name);
    }
}

